/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.PalmTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class PalmTreeFeature
extends BOPTreeFeature<PalmTreeConfiguration> {
    public PalmTreeFeature(Codec<PalmTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 startPos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        PalmTreeConfiguration config = (PalmTreeConfiguration)configBase;
        while (startPos.method_10264() >= world.method_31607() + 1 && world.method_22347(startPos) || world.method_8320(startPos).method_26164(class_3481.field_15503)) {
            startPos = startPos.method_10074();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = true;
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        if (random.method_43048(8) == 0) {
            slant = false;
        }
        double baseSlant = (double)(5 + random.method_43048(30)) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        class_2338 pos = startPos.method_10084();
        if (!this.checkSpace((class_1936)world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            class_2338 offsetPos = pos.method_10086(step);
            if (slant) {
                offsetPos = pos.method_10086(step).method_10079(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.placeLog((class_1936)world, offsetPos, logs, config);
                this.generateLeavesTop((class_1936)world, offsetPos, leavesRadius, leaves, config);
                break;
            }
            this.placeLog((class_1936)world, offsetPos, logs, config);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(class_1936 world, class_2338 pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (pos1.method_10264() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(class_1936 world, class_2338 pos, int maxRadius, class_4647.class_8179 leaves, PalmTreeConfiguration config) {
        this.placeLeaves(world, pos.method_10069(2, -2, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, -2, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, -2, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, -2, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, -1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, -1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, -1, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, -1, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, -1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, -1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, -1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, -1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 0, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 0, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 0, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 0, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 0, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 0, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 0, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 0, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 0, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 0, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 1, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 1, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 1, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 1, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 2, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 2, -1), leaves, config);
    }
}

