/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import java.util.function.Function;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.manager.GuiManagerDist;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiManager<T extends GuiManagerDist> {
    public static final NamedHandlerRegistry<GuiManagerType> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiManagerType<GuiManagerItem> ITEM = GuiManager.register("item", GuiManagerItem.class, GuiManagerItem::new);
    public final GuiLayer layer;
    public final T dist;

    public static <T extends GuiManager> GuiManagerType<T> register(String name, Class<T> managerClass, Function<GuiLayer, T> factory) {
        GuiManagerType<T> type = new GuiManagerType<T>(name, managerClass, factory);
        REGISTRY.register(name, type);
        return type;
    }

    public GuiManager(GuiLayer layer) {
        this.layer = layer;
        this.dist = layer.createDist(this);
    }

    public void tick() {
    }

    public void closed() {
    }

    public record GuiManagerType<T extends GuiManager>(String name, Class<T> managerClass, Function<GuiLayer, T> factory) {
    }
}

