/*
 * Decompiled with CFR 0.152.
 */
package me.contaria.fastquit;

import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.contaria.fastquit.FastQuitConfig;
import me.contaria.fastquit.TextHelper;
import me.contaria.fastquit.WaitingScreen;
import me.contaria.fastquit.WorldInfo;
import me.contaria.fastquit.mixin.LevelStorageSessionAccessor;
import me.contaria.fastquit.mixin.MinecraftClientAccessor;
import me.contaria.fastquit.mixin.MinecraftServerAccessor;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public final class FastQuit
implements ClientModInitializer {
    public static final ModMetadata FASTQUIT = ((ModContainer)FabricLoader.getInstance().getModContainer("fastquit").orElseThrow()).getMetadata();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOG_PREFIX = "[" + FASTQUIT.getName() + "] ";
    public static final FastQuitConfig CONFIG = (FastQuitConfig)AutoConfig.register(FastQuitConfig.class, Toml4jConfigSerializer::new).getConfig();
    public static final boolean HAS_WORLDPLAYTIME = FabricLoader.getInstance().isModLoaded("worldplaytime");
    public static final Map<class_1132, WorldInfo> savingWorlds = Collections.synchronizedMap(new HashMap());
    public static final List<class_32.class_5143> occupiedSessions = Collections.synchronizedList(new ArrayList());

    public void onInitializeClient() {
        FastQuit.log("Initialized");
    }

    public static void log(String msg) {
        LOGGER.info(LOG_PREFIX + msg);
    }

    public static void warn(String msg) {
        LOGGER.warn(LOG_PREFIX + msg);
    }

    public static void error(String msg, Throwable throwable) {
        LOGGER.error(LOG_PREFIX + msg, throwable);
    }

    public static void exit() {
        try {
            FastQuit.log("Exiting FastQuit.");
            FastQuit.wait(savingWorlds.keySet());
        }
        catch (Throwable throwable) {
            FastQuit.error("Something went horribly wrong when exiting FastQuit!", throwable);
            savingWorlds.forEach((server, info) -> {
                try {
                    server.method_3777().join();
                }
                catch (Throwable throwable2) {
                    FastQuit.error("Failed to wait for \"" + server.method_27728().method_150() + "\"", throwable2);
                }
            });
        }
    }

    public static void wait(class_1132 server) {
        FastQuit.wait(Collections.singleton(server), null);
    }

    public static void wait(class_1132 server, @Nullable CallbackInfo cancellable) {
        FastQuit.wait(Collections.singleton(server), cancellable);
    }

    public static void wait(Collection<class_1132> servers) {
        FastQuit.wait(servers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Collection<class_1132> servers, @Nullable CallbackInfo cancellable) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (!client.method_18854()) {
            if (servers.stream().anyMatch(server -> Thread.currentThread() == server.method_3777())) {
                throw new IllegalStateException("Tried to call FastQuit.wait(...) from one of the servers it's supposed to wait for.");
            }
            client.method_20493(() -> FastQuit.wait(servers)).join();
            return;
        }
        class_437 oldScreen = client.field_1755;
        class_5250 stillSaving = TextHelper.translatable("fastquit.screen.waiting", String.join((CharSequence)"\" & \"", servers.stream().map(server -> server.method_27728().method_150()).toList()));
        FastQuit.log(stillSaving.getString());
        servers.forEach(server -> server.method_3777().setPriority(5));
        try {
            client.method_1507((class_437)new WaitingScreen((class_2561)stillSaving, cancellable));
            while (servers.stream().anyMatch(server -> !server.method_16043())) {
                if (cancellable != null && cancellable.isCancelled()) {
                    if (FastQuit.CONFIG.backgroundPriority != 0) {
                        servers.forEach(server -> server.method_3777().setPriority(FastQuit.CONFIG.backgroundPriority));
                    }
                    FastQuit.log("Cancelled waiting for currently saving worlds.");
                    break;
                }
                ((MinecraftClientAccessor)client).fastquit$render(false);
            }
        }
        finally {
            if (oldScreen != null && oldScreen.getClass().getName().equals("caeruleusTait.WorldGen.gui.screens.WGConfigScreen")) {
                client.field_1755 = oldScreen;
            } else {
                client.method_29970(oldScreen);
            }
        }
    }

    public static Optional<class_1132> getSavingWorld(Path path) {
        return savingWorlds.keySet().stream().filter(server -> ((LevelStorageSessionAccessor)((MinecraftServerAccessor)server).fastquit$getSession()).fastquit$getDirectory().comp_732().equals(path)).findFirst();
    }

    public static Optional<class_1132> getSavingWorld(class_32.class_5143 session) {
        return savingWorlds.keySet().stream().filter(server -> ((MinecraftServerAccessor)server).fastquit$getSession() == session).findFirst();
    }

    public static Optional<class_32.class_5143> getSession(Path path) {
        return FastQuit.getSavingWorld(path).flatMap(server -> {
            class_32.class_5143 session;
            class_32.class_5143 class_51432 = session = ((MinecraftServerAccessor)server).fastquit$getSession();
            synchronized (session) {
                if (((LevelStorageSessionAccessor)session).fastquit$getLock().method_26802()) {
                    occupiedSessions.add(session);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Optional.of(session);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Optional.empty();
            }
        });
    }
}

