/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.client;

import java.util.HashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.network.NetworkVersions;
import net.blay09.mods.balm.api.network.ServerboundModListMessage;
import net.blay09.mods.balm.fabric.client.FabricBalmClientRuntime;
import net.blay09.mods.balm.fabric.client.rendering.FabricBalmModels;
import net.blay09.mods.balm.fabric.network.FabricBalmNetworking;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;

public class FabricBalmClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ((FabricBalmClientRuntime)BalmClient.getRuntime()).initializeRuntime();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> FabricBalmNetworking.initializeClientHandlers());
        ModelLoadingPlugin.register((ModelLoadingPlugin)((FabricBalmModels)BalmClient.getModels()));
        Balm.getEvents().onEvent(ConnectedToServerEvent.class, event -> {
            FabricBalmNetworking networking = (FabricBalmNetworking)Balm.getNetworking();
            HashMap<String, NetworkVersions> modVersions = new HashMap<String, NetworkVersions>();
            for (String modId : networking.getRegisteredMods()) {
                networking.getNetworkVersions(modId, BalmEnvironment.CLIENT).ifPresent(clientVersions -> modVersions.put(modId, (NetworkVersions)clientVersions));
            }
            Balm.getNetworking().sendToServer(new ServerboundModListMessage(modVersions));
        });
    }
}

