/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.stats.panel.StatsSummaryPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.ItemStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortItemsBy;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui.screen.hud.entry.StatsHudItemEntry;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.BSStatsTab;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

@Virtual
@ApiStatus.Internal
public class ItemStatsTab
extends BSStatsTab<SUItemStat> {
    private static final int ITEMS_PER_PAGE = 700;

    @Override
    @Virtual
    public class_2561 getName() {
        return TextUtils.translatable((String)"stat.itemsButton", (Object[])new Object[0]);
    }

    @Override
    @Virtual
    public void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        IStatsProvider stats = initContext.getStatsProvider();
        StatFilterSettings filters = initContext.getFilterSettings();
        FilterGroupBy filter_group = (FilterGroupBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_GROUP, (Object)FilterGroupBy.DEFAULT));
        FilterSortItemsBy filter_sort = (FilterSortItemsBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SORT_ITEMS, (Object)FilterSortItemsBy.DEFAULT));
        List<SUItemStat> itemStats = SUItemStat.getItemStats(stats, this.getPredicate(filters));
        int itemStatsSize = itemStats.size();
        filter_sort.sortItemStats(itemStats);
        if (itemStatsSize > 0) {
            this.initPageChooser(initContext, itemStatsSize, 700);
            int maxPages = Math.max((int)Math.ceil((double)itemStatsSize / 700.0), 1);
            int page = Math.min(this.getPageFilter(filters).get(), maxPages);
            int from = Math.max(page - 1, 0) * 700;
            int to = Math.max(Math.min(page * 700, itemStatsSize), from);
            List subl = TUtils.safeSubList(itemStats, (int)from, (int)to);
            Map statGroups = filter_group == FilterGroupBy.DEFAULT ? this.getDefaultGroupFilter().apply(subl, new SUItemStat[0]) : filter_group.apply(subl, new SUItemStat[0]);
            for (Map.Entry statGroup : statGroups.entrySet()) {
                class_2561 group = (class_2561)statGroup.getKey();
                StatsTabUtils.initGroupLabel(panel, (class_2561)(group != null ? group : TextUtils.literal((String)"*")));
                this.initStats(panel, (Collection)statGroup.getValue(), widget -> this.processWidget((ItemStatWidget)((Object)widget)));
            }
            StatsSummaryPanel summary = ItemStatsTab.initStatsSummary(panel);
            summary.summarizeItemStats(itemStats);
            summary.autoHeight();
            this.initPageChooser(initContext, itemStatsSize, 700);
        }
    }

    @Override
    @Virtual
    protected void initExtraFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initGroupByFilter(initContext);
        StatsTabUtils.initSortItemsByFilter(initContext);
    }

    @Virtual
    protected FilterGroupBy getDefaultGroupFilter() {
        return FilterGroupBy.DEFAULT;
    }

    @Virtual
    protected void initStats(TPanelElement panel, Collection<SUItemStat> stats, Consumer<ItemStatWidget> processWidget) {
        int wmp = panel.getWidth() - panel.getScrollPadding() * 2;
        int nextX = panel.getScrollPadding();
        int nextY = UILayout.nextChildBottomY((TParentElement)panel) - panel.getY();
        for (SUItemStat stat : stats) {
            ItemStatWidget statElement = new ItemStatWidget(nextX, nextY, stat);
            panel.addChild((TElement)statElement, true);
            if (processWidget != null) {
                processWidget.accept(statElement);
            }
            if ((nextX += 24) + 21 < wmp) continue;
            nextX = panel.getScrollPadding();
            nextY = UILayout.nextChildBottomY((TParentElement)panel) - panel.getY() + 3;
        }
    }

    @Virtual
    protected void processWidget(ItemStatWidget widget) {
        widget.eContextMenu.register((__, cMenu) -> {
            if (!(((SUItemStat)widget.getStat()).getStatsProvider() instanceof LocalPlayerStatsProvider)) {
                return;
            }
            cMenu.addButton((class_2561)BST.hud_pinStat(), ___ -> {
                BetterStatsHudScreen hud = BetterStatsHudScreen.getInstance();
                hud.setParentScreen(BetterStatsClient.MC_CLIENT.field_1755);
                hud.addEntry(new StatsHudItemEntry((SUItemStat)widget.getStat()));
                BetterStatsClient.MC_CLIENT.method_1507(hud.getAsScreen());
            });
            cMenu.addButton((class_2561)TextUtils.translatable((String)"mco.selectServer.close", (Object[])new Object[0]), ___ -> {});
        });
    }
}

