/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify;

import btw.lowercase.skyboxify.api.SkyboxifyImpl;
import btw.lowercase.skyboxify.config.SkyboxifyConfig;
import btw.lowercase.skyboxify.events.LevelTickEvent;
import btw.lowercase.skyboxify.events.SkyRenderEvent;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Path;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.visuals.legacy.lightconfig.lib.v1.events.EventManager;

public final class Skyboxify {
    public static final Path DEBUG_FOLDER = class_310.method_1551().field_1697.toPath().resolve("debug_skyboxify");
    private static final Logger logger = LoggerFactory.getLogger(Skyboxify.class);
    private static final EventManager globalEventManager = new EventManager();

    public static class_2960 locationOrNull(String path) {
        return class_2960.method_60655((String)"skyboxify", (String)path);
    }

    public static void initialize() {
        SkyboxifyConfig config = SkyboxifyImpl.config();
        config.load();
        globalEventManager.listen(LevelTickEvent.Client.class, event -> SkyboxifyImpl.skyboxManager().tick(event.getLevel()));
        globalEventManager.listen(SkyRenderEvent.Celestial.class, event -> {
            if (config.enabled.isEnabled()) {
                SkyRenderEvent.Celestial.Type type = event.getType();
                if (!config.renderSunMoon.isEnabled() && (type == SkyRenderEvent.Celestial.Type.SUN || type == SkyRenderEvent.Celestial.Type.MOON) || !config.renderStars.isEnabled() && type == SkyRenderEvent.Celestial.Type.STARS) {
                    event.setCancelled(true);
                }
            }
        });
        globalEventManager.listen(SkyRenderEvent.EndSky.After.class, event -> {
            if (SkyboxifyImpl.skyboxManager().isEnabled()) {
                Skyboxify.renderSkyboxes(event.getLevel(), 0.0f);
            }
        });
        globalEventManager.listen(SkyRenderEvent.SunMoonStars.class, event -> {
            class_638 level = event.getLevel();
            if (SkyboxifyImpl.skyboxManager().isEnabled()) {
                Skyboxify.renderSkyboxes(level, event.getTickDelta());
                if (SkyboxifyImpl.skyboxManager().containsEnabled((class_5321<class_1937>)class_1937.field_25180) && level.method_27983().equals(class_1937.field_25180)) {
                    event.setCancelled(true);
                }
            }
        });
    }

    private static void renderSkyboxes(class_638 level, float tickDelta) {
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewStack()).rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        for (Skybox skybox : SkyboxifyImpl.skyboxManager().getActive()) {
            SkyboxRenderer.INSTANCE.render(skybox, modelViewMatrix, level, tickDelta);
        }
    }

    @Generated
    private Skyboxify() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static EventManager getGlobalEventManager() {
        return globalEventManager;
    }
}

