/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.command;

import btw.lowercase.skyboxify.Skyboxify;
import btw.lowercase.skyboxify.api.SkyboxifyImpl;
import btw.lowercase.skyboxify.screen.SkyboxListScreen;
import btw.lowercase.skyboxify.skybox.SkyLayer;
import btw.lowercase.skyboxify.skybox.Skybox;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class SkyboxifyCommand
extends LiteralArgumentBuilder<FabricClientCommandSource>
implements Command<FabricClientCommandSource> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public SkyboxifyCommand() {
        super("skyboxify");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.executes(this)).then(ClientCommandManager.literal((String)"debug").executes((Command)new Debug()))).then(ClientCommandManager.literal((String)"dump").executes((Command)new Dump()));
    }

    public int run(CommandContext<FabricClientCommandSource> context) {
        class_310 minecraft = class_310.method_1551();
        minecraft.method_63588(() -> minecraft.method_1507(SkyboxifyImpl.config().getConfigScreen(minecraft.field_1755)));
        return 1;
    }

    private static void error(CommandContext<FabricClientCommandSource> context, String message) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
    }

    private static void success(CommandContext<FabricClientCommandSource> context, String message) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1060));
    }

    private static class Debug
    implements Command<FabricClientCommandSource> {
        private Debug() {
        }

        public int run(CommandContext<FabricClientCommandSource> context) {
            class_310 minecraft = class_310.method_1551();
            minecraft.method_63588(() -> minecraft.method_1507((class_437)new SkyboxListScreen(minecraft.field_1755, SkyboxifyImpl.skyboxManager().getLoaded())));
            return 1;
        }
    }

    private static class Dump
    implements Command<FabricClientCommandSource> {
        private Dump() {
        }

        public int run(CommandContext<FabricClientCommandSource> context) {
            if (!Files.isDirectory(Skyboxify.DEBUG_FOLDER, new LinkOption[0])) {
                Files.delete(Skyboxify.DEBUG_FOLDER);
            }
            if (!Files.exists(Skyboxify.DEBUG_FOLDER, new LinkOption[0])) {
                Files.createDirectories(Skyboxify.DEBUG_FOLDER, new FileAttribute[0]);
            }
            for (Skybox skybox : SkyboxifyImpl.skyboxManager().getLoaded()) {
                class_2960 dimension;
                Path dimensionFolder;
                Path packFolder = Skyboxify.DEBUG_FOLDER.resolve(skybox.getPackName().replaceAll("/", "+").replaceAll(" ", "_"));
                if (!Files.exists(packFolder, new LinkOption[0])) {
                    Files.createDirectory(packFolder, new FileAttribute[0]);
                }
                if (!Files.exists(dimensionFolder = packFolder.resolve((dimension = skybox.getDimension().method_29177()).method_12836()).resolve(dimension.method_12832()), new LinkOption[0])) {
                    Files.createDirectories(dimensionFolder, new FileAttribute[0]);
                }
                for (SkyLayer layer : skybox.getLayers()) {
                    try {
                        JsonElement element;
                        String id = Path.of(layer.id().method_12832(), new String[0]).getFileName().toString();
                        if (id.endsWith(".properties")) {
                            id = id.substring(0, id.length() - 11);
                        }
                        if ((element = (JsonElement)SkyLayer.CODEC.encode((Object)layer, (DynamicOps)JsonOps.INSTANCE, null).getOrThrow(message -> {
                            SkyboxifyCommand.error(context, message);
                            return null;
                        })) == null) {
                            SkyboxifyCommand.error(context, "Failed to encode layer \"" + id + "\"");
                            continue;
                        }
                        Files.writeString(dimensionFolder.resolve(id + ".json"), (CharSequence)GSON.toJson(element), new OpenOption[0]);
                    }
                    catch (IOException exception) {
                        SkyboxifyCommand.error(context, "Failed to encode layer " + String.valueOf(layer.id()));
                        SkyboxifyCommand.error(context, exception.toString());
                    }
                }
            }
            SkyboxifyCommand.success(context, "Active Skybox's have been dumped to " + String.valueOf(Skyboxify.DEBUG_FOLDER));
            return 1;
        }
    }
}

