/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.api.SkyboxifyImpl;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxParser;
import btw.lowercase.skyboxify.utils.ParserCodecs;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkyboxResourceHelper
implements class_3302 {
    private static final String OPTIFINE_SKY_PARENT = "optifine/sky";
    private static final String SKY_PATTERN_ENDING = "(?<dimension>[\\w-]+)/(?<name>\\w+).properties$";
    private static final Pattern OPTIFINE_SKY_PATTERN = Pattern.compile("optifine/sky/(?<dimension>[\\w-]+)/(?<name>\\w+).properties$");
    private static final String MCPATCHER_SKY_PARENT = "mcpatcher/sky";
    private static final Pattern MCPATCHER_SKY_PATTERN = Pattern.compile("mcpatcher/sky/(?<dimension>[\\w-]+)/(?<name>\\w+).properties$");
    private static final Logger LOGGER = LoggerFactory.getLogger(SkyboxResourceHelper.class);

    private static class_3262.class_7664 filterResource(List<class_2960> list) {
        return (resourceLocation, ioSupplier) -> {
            if (resourceLocation.method_12832().endsWith(".properties")) {
                list.add((class_2960)resourceLocation);
            }
        };
    }

    private static Comparator<class_2960> compareLocations(Pattern pattern) {
        return Comparator.comparing(class_2960::method_12832, (first, second) -> {
            Matcher matcherId1 = pattern.matcher((CharSequence)first);
            Matcher matcherId2 = pattern.matcher((CharSequence)second);
            if (matcherId1.find() && matcherId2.find()) {
                int a = ParserCodecs.safeParseInteger(matcherId1.group("name").replace("sky", ""), -1);
                int b = ParserCodecs.safeParseInteger(matcherId2.group("name").replace("sky", ""), -1);
                if (a >= 0 && b >= 0) {
                    return a - b;
                }
            }
            return 0;
        });
    }

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, @NotNull Executor backgroundExecutor, class_3302.class_4045 preparationBarrier, @NotNull Executor gameExecutor) {
        class_3300 theResourceManager = sharedState.method_72361();
        return CompletableFuture.runAsync(() -> {
            if (SkyboxifyImpl.config().enabled.isEnabled()) {
                SkyboxifyImpl.skyboxManager().clearSkyboxes();
                theResourceManager.method_29213().forEach(pack -> {
                    int count;
                    ArrayList<class_2960> skies;
                    ArrayList<class_2960> optifineSkies = new ArrayList<class_2960>();
                    pack.method_14408(class_3264.field_14188, "minecraft", OPTIFINE_SKY_PARENT, SkyboxResourceHelper.filterResource(optifineSkies));
                    optifineSkies.sort(SkyboxResourceHelper.compareLocations(OPTIFINE_SKY_PATTERN));
                    ArrayList<class_2960> mcpatcherSkies = new ArrayList<class_2960>();
                    pack.method_14408(class_3264.field_14188, "minecraft", MCPATCHER_SKY_PARENT, SkyboxResourceHelper.filterResource(mcpatcherSkies));
                    mcpatcherSkies.sort(SkyboxResourceHelper.compareLocations(MCPATCHER_SKY_PATTERN));
                    Pattern skyPattern = OPTIFINE_SKY_PATTERN;
                    if (optifineSkies.isEmpty()) {
                        if (SkyboxifyImpl.config().debug.isEnabled()) {
                            LOGGER.info("Couldn't find any skies inside \"{}\" under \"optifine\", searching for skies under \"mcpatcher\" instead...", (Object)pack.method_14409());
                        }
                        skyPattern = MCPATCHER_SKY_PATTERN;
                    }
                    ArrayList<class_2960> arrayList = skies = skyPattern == OPTIFINE_SKY_PATTERN ? optifineSkies : mcpatcherSkies;
                    if (!skies.isEmpty() && (count = this.parseSkyboxesInPack((class_3262)pack, (List<class_2960>)skies, skyPattern)) > 0 && SkyboxifyImpl.config().debug.isEnabled()) {
                        LOGGER.info("Loaded {} {} from \"{}\"!", new Object[]{count, count == 1 ? "skies" : "sky", pack.method_14409()});
                    }
                });
            }
        }).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
    }

    private int parseSkyboxesInPack(class_3262 packResources, List<class_2960> skies, Pattern skyPattern) {
        HashMap layers = new HashMap();
        int count = 0;
        skies.forEach(id -> {
            Matcher matcher = skyPattern.matcher(id.method_12832());
            if (!matcher.find()) {
                return;
            }
            String dimension = matcher.group("dimension");
            String name = matcher.group("name");
            if (dimension == null || name == null) {
                return;
            }
            if (name.equals("moon_phases") || name.equals("sun")) {
                if (SkyboxifyImpl.config().debug.isEnabled()) {
                    LOGGER.warn("Skipping {}, moon_phases/sun aren't currently supported!", id);
                }
                return;
            }
            class_7367 resource = packResources.method_14405(class_3264.field_14188, id);
            if (resource == null) {
                LOGGER.error("Error trying to read namespaced identifier: {}", id);
                return;
            }
            Properties properties = new Properties();
            try {
                InputStream inputStream = (InputStream)resource.get();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException ignored) {
                LOGGER.error("Error trying to read properties from: {}", id);
                return;
            }
            JsonObject json = SkyboxParser.parseSkyProperties(properties, id, packResources);
            if (json != null) {
                layers.computeIfAbsent(dimension, key -> new JsonArray()).add((JsonElement)json);
            }
        });
        for (Map.Entry entry : layers.entrySet()) {
            JsonArray skyLayers = (JsonArray)entry.getValue();
            if (skyLayers.isEmpty()) continue;
            int dimensionId = Integer.parseInt(((String)entry.getKey()).replace("world", ""));
            class_2960 dimension = SkyboxifyImpl.getInstance().getModernDimension(dimensionId);
            if (dimension == null) {
                if (!SkyboxifyImpl.config().debug.isEnabled()) continue;
                LOGGER.warn("Tried to load Skybox with legacy dimension id {} but no modern dimension identifier mapping was found, skipping!", (Object)dimensionId);
                continue;
            }
            JsonObject skyboxJson = new JsonObject();
            skyboxJson.addProperty("dimension", dimension.toString());
            skyboxJson.add("layers", (JsonElement)skyLayers);
            Skybox skybox = (Skybox)((Pair)Skybox.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)skyboxJson).getOrThrow()).getFirst();
            skybox.setPackName(packResources.method_14409());
            SkyboxifyImpl.skyboxManager().addSkybox(skybox);
            ++count;
        }
        return count;
    }
}

