/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.utils;

import btw.lowercase.skyboxify.skybox.components.Weather;
import com.google.common.collect.Range;
import java.text.DecimalFormat;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_3532;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public final class CommonUtils {
    private static final DecimalFormat VECTOR_FORMAT = new DecimalFormat("# .##");

    public static int normalizeTickTime(int tickTime) {
        int result = tickTime % 24000;
        if (result < 0) {
            result += 24000;
        }
        return result;
    }

    public static boolean checkRanges(double value, List<btw.lowercase.skyboxify.skybox.components.Range> rangeEntries) {
        return rangeEntries.isEmpty() || rangeEntries.stream().anyMatch(range -> Range.closed((Comparable)Float.valueOf(range.min()), (Comparable)Float.valueOf(range.max())).contains((Comparable)Float.valueOf((float)value)));
    }

    public static boolean isInTimeInterval(int currentTime, int startTime, int endTime) {
        if (currentTime < 0 || currentTime >= 24000) {
            return false;
        }
        if (startTime <= endTime) {
            return currentTime >= startTime && currentTime <= endTime;
        }
        return currentTime >= startTime || currentTime <= endTime;
    }

    public static float calculateConditionAlphaValue(float maxAlpha, float minAlpha, float lastAlpha, int duration, boolean in) {
        if (duration == 0) {
            return lastAlpha;
        }
        if (in && maxAlpha == lastAlpha) {
            return maxAlpha;
        }
        if (!in && lastAlpha == minAlpha) {
            return minAlpha;
        }
        float alphaChange = (maxAlpha - minAlpha) / (float)duration;
        float result = in ? lastAlpha + alphaChange : lastAlpha - alphaChange;
        return class_3532.method_15363((float)result, (float)minAlpha, (float)maxAlpha);
    }

    public static float getWeatherAlpha(List<Weather> weatherConditions, float rainStrength, float thunderStrength) {
        float alpha = 1.0f - rainStrength;
        float calculatedRainStrength = rainStrength - thunderStrength;
        float weatherAlpha = 0.0f;
        if (weatherConditions.contains((Object)Weather.CLEAR)) {
            weatherAlpha += alpha;
        }
        if (weatherConditions.contains((Object)Weather.RAIN)) {
            weatherAlpha += calculatedRainStrength;
        }
        if (weatherConditions.contains((Object)Weather.THUNDER)) {
            weatherAlpha += thunderStrength;
        }
        return class_3532.method_15363((float)weatherAlpha, (float)0.0f, (float)1.0f);
    }

    public static void rotate(Matrix4f pose, float angleRads, Vector3fc axis) {
        Quaternionf quat = new Quaternionf(new AxisAngle4f(-angleRads, axis));
        float qxy = quat.x * quat.y;
        float qyz = quat.y * quat.z;
        float qzx = quat.z * quat.x;
        float qxw = quat.x * quat.w;
        float qyw = quat.y * quat.w;
        float qzw = quat.z * quat.w;
        float j = 2.0f * quat.x * quat.x;
        float k = 2.0f * quat.y * quat.y;
        float l = 2.0f * quat.z * quat.z;
        pose.mul0((Matrix4fc)new Matrix4f().m00(1.0f - k - l).m11(1.0f - l - j).m22(1.0f - j - k).m33(1.0f).m10(2.0f * (qxy + qzw)).m01(2.0f * (qxy - qzw)).m20(2.0f * (qzx - qyw)).m02(2.0f * (qzx + qyw)).m21(2.0f * (qyz + qxw)).m12(2.0f * (qyz - qxw)));
    }

    public static String vectorToString(Vector3fc vector3fc) {
        String x = VECTOR_FORMAT.format(vector3fc.x()).trim();
        String y = VECTOR_FORMAT.format(vector3fc.y()).trim();
        String z = VECTOR_FORMAT.format(vector3fc.z()).trim();
        return String.format("[x=%s, y=%s, z=%s]", x, y, z);
    }

    @Generated
    private CommonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

