/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.model;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.render.FrozenLibRenderTypes;
import net.frozenblock.wilderwild.client.renderer.entity.state.JellyfishRenderState;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class JellyfishModel
extends class_583<JellyfishRenderState> {
    private static final int JELLYFISH_TENTACLES = WWEntityConfig.get().jellyfish.jellyfishTentacles;
    private static final float EIGHT_PI = -0.13962634f;
    private final class_630 bone;
    private final class_630 body;
    private final class_630 tentacleBase;
    private final class_630 armBase;
    private final class_630[] tentacles = new class_630[JELLYFISH_TENTACLES];
    private final class_630[] planeTentacles = new class_630[JELLYFISH_TENTACLES];

    public JellyfishModel(@NotNull class_630 root) {
        super(root, FrozenLibRenderTypes::entityTranslucentEmissiveFixed);
        this.bone = root.method_32086("bone");
        this.body = this.bone.method_32086("body");
        this.tentacleBase = this.bone.method_32086("tentacleBase");
        this.armBase = this.bone.method_32086("armBase");
        Arrays.setAll(this.tentacles, i -> this.tentacleBase.method_32086(JellyfishModel.createTentacleName(i, false)));
        Arrays.setAll(this.planeTentacles, i -> this.tentacleBase.method_32086(JellyfishModel.createTentacleName(i, true)));
    }

    @NotNull
    public static class_5607 createBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        class_5610 bone = partDefinition.method_32117("bone", class_5606.method_32108(), class_5603.field_27701);
        bone.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -2.0f, -4.0f, 8.0f, 5.0f, 8.0f).method_32101(4, 13).method_32097(-3.0f, -1.0f, -3.0f, 6.0f, 3.0f, 6.0f), class_5603.field_27701);
        class_5610 tentacleBase = bone.method_32117("tentacleBase", class_5606.method_32108(), class_5603.field_27701);
        JellyfishModel.makeTentacles(tentacleBase, JELLYFISH_TENTACLES);
        JellyfishModel.makePlaneTentacles(tentacleBase, JELLYFISH_TENTACLES);
        class_5606 arm = class_5606.method_32108().method_32101(0, 25).method_32098(0.0f, -3.0f, 0.0f, 16.0f, 6.0f, 0.0f, new class_5605(0.001f));
        class_5610 armBase = bone.method_32117("armBase", class_5606.method_32108(), class_5603.method_32092((float)0.0f, (float)0.7853982f, (float)0.0f));
        armBase.method_32117("arms1", arm, class_5603.method_32092((float)0.0f, (float)0.0f, (float)1.5707964f));
        armBase.method_32117("arms2", arm, class_5603.method_32092((float)1.5707964f, (float)0.0f, (float)1.5707964f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)32, (int)32);
    }

    private static void makeTentacles(class_5610 partDefinition, int amount) {
        class_5606 tentacle = class_5606.method_32108().method_32101(0, 13).method_32097(-0.5f, 0.0f, 0.0f, 1.0f, 10.0f, 1.0f);
        for (int i = 0; i < amount; ++i) {
            float rot = (float)i * (float)Math.PI * 2.0f / (float)amount;
            partDefinition.method_32117(JellyfishModel.createTentacleName(i, false), tentacle, class_5603.method_32091((float)(class_3532.method_15362((float)rot) * 2.5f), (float)0.0f, (float)(class_3532.method_15374((float)rot) * 2.5f), (float)0.0f, (float)((float)i * (float)Math.PI * -2.0f / (float)amount + 1.5707964f), (float)0.0f));
        }
    }

    private static void makePlaneTentacles(class_5610 partDefinition, int amount) {
        class_5606 tentacle = class_5606.method_32108().method_32101(0, 14).method_32098(-0.5f, 0.0f, 1.0f, 1.0f, 10.0f, 0.0f, new class_5605(0.001f));
        class_5606 altTentacle = class_5606.method_32108().method_32101(2, 14).method_32098(-0.5f, 0.0f, 1.0f, 1.0f, 10.0f, 0.0f, new class_5605(0.001f));
        for (int i = 0; i < amount; ++i) {
            float rot = (float)i * (float)Math.PI * 2.0f / (float)amount;
            partDefinition.method_32117(JellyfishModel.createTentacleName(i, true), i % 2 == 0 ? altTentacle : tentacle, class_5603.method_32091((float)(class_3532.method_15362((float)rot) * 2.75f), (float)0.0f, (float)(class_3532.method_15374((float)rot) * 2.75f), (float)0.0f, (float)((float)i * (float)Math.PI * -2.0f / (float)amount + 1.5707964f), (float)0.0f));
        }
    }

    @NotNull
    private static String createTentacleName(int number, boolean plane) {
        String tentacle = !plane ? "tentacle" : "tentacle_plane";
        return tentacle + number;
    }

    public void setupAnim(@NotNull JellyfishRenderState renderState) {
        float armSquash;
        float squash;
        super.method_2819((Object)renderState);
        this.bone.field_3654 = renderState.jellyXRot;
        this.tentacleBase.field_3654 = renderState.tentXRot - renderState.jellyXRot;
        this.armBase.field_3654 = renderState.armXRot - renderState.jellyXRot;
        float walkPos = renderState.field_53450;
        float walkSpeed = renderState.field_53451;
        float animation = walkPos * 2.0f;
        float movementDelta = Math.min(walkSpeed * 26.666666f, 1.0f);
        float sin = (float)(-Math.sin(animation));
        float sinIdle = (float)(Math.sin(renderState.field_53328 * 0.1f) * (double)0.2f);
        float squashStretch = 1.0f + -sin * 0.25f;
        this.body.field_37938 = squash = class_3532.method_16439((float)movementDelta, (float)(sinIdle + 1.0f), (float)squashStretch);
        this.body.field_37940 = squash;
        this.body.field_37939 = class_3532.method_16439((float)movementDelta, (float)(-sinIdle + 1.0f), (float)(1.25f + sin * 0.75f));
        this.body.field_3656 = class_3532.method_16439((float)movementDelta, (float)0.0f, (float)(3.5f - squashStretch * 3.5f));
        this.armBase.field_3656 = this.tentacleBase.field_3656 = class_3532.method_16439((float)movementDelta, (float)(-sinIdle * 2.0f + 1.8f), (float)((6.0f - squashStretch * 5.0f) * 1.5f)) * 1.5f;
        float armSinIdle = (float)(Math.sin(renderState.field_53328 * 0.1f - 1.0f) * (double)0.2f);
        this.armBase.field_37938 = armSquash = armSinIdle * 1.25f + 1.0f;
        this.armBase.field_37940 = armSquash;
        this.armBase.field_37939 = -armSinIdle * 0.75f + 0.75f;
        float tentRot = -class_3532.method_17821((float)movementDelta, (float)((float)(-Math.sin((renderState.field_53328 - 10.0f) * 0.1f) * (double)0.2f) + -0.13962634f), (float)((float)(-Math.sin(animation + 5.0f) * 20.0 - 7.5) * ((float)Math.PI / 180)));
        class_630[] visibleTentacles = !WWEntityConfig.Client.JELLYFISH_PLANE_TENTACLES ? this.tentacles : this.planeTentacles;
        class_630[] invisibleTentacles = !WWEntityConfig.Client.JELLYFISH_PLANE_TENTACLES ? this.planeTentacles : this.tentacles;
        for (class_630 modelPart : visibleTentacles) {
            modelPart.field_3665 = true;
            modelPart.field_3657 *= squash;
            modelPart.field_3655 *= squash;
            modelPart.field_3654 = tentRot;
        }
        for (class_630 modelPart : invisibleTentacles) {
            modelPart.field_3665 = false;
        }
        this.armBase.field_3665 = WWEntityConfig.Client.JELLYFISH_ORAL_ARM;
    }
}

