/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.minecraft.datafixers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.DisplayLanternComponentizationFix;
import net.minecraft.class_1208;
import net.minecraft.class_1220;
import org.jetbrains.annotations.NotNull;

public final class DisplayLanternItemComponentizationFix
extends DataFix {
    private static final String ITEM_ID = WWConstants.string("display_lantern");

    public DisplayLanternItemComponentizationFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    @NotNull
    private static Dynamic<?> fixOccupants(@NotNull Dynamic<?> dynamic) {
        OptionalDynamic optionalFireflies = dynamic.get("Fireflies");
        if (optionalFireflies.result().isEmpty()) {
            return dynamic.createList(Stream.empty());
        }
        List oldDynamics = optionalFireflies.orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        ArrayList newDynamics = Lists.newArrayList();
        for (Dynamic embeddedDynamic : oldDynamics) {
            newDynamics.add(DisplayLanternComponentizationFix.fixOccupant(embeddedDynamic));
        }
        return ((Dynamic)optionalFireflies.result().get()).createList(newDynamics.stream());
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(class_1208.field_5712);
        return this.fixTypeEverywhereTyped("Display Lantern ItemStack componentization fix", type, DisplayLanternItemComponentizationFix.createFixer(type, this::fixItemStack));
    }

    @NotNull
    private static UnaryOperator<Typed<?>> createFixer(@NotNull Type<?> type, UnaryOperator<Dynamic<?>> unaryOperator) {
        OpticFinder idFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)class_1208.field_5713.typeName(), (Type)class_1220.method_28295()));
        OpticFinder components = type.findField("components");
        return typed -> {
            Optional optional = typed.getOptional(idFinder);
            return optional.isPresent() && ((String)((Pair)optional.get()).getSecond()).equals(ITEM_ID) ? typed.updateTyped(components, typedx -> typedx.update(DSL.remainderFinder(), (Function)unaryOperator)) : typed;
        };
    }

    private Dynamic<?> fixItemStack(@NotNull Dynamic<?> componentData) {
        OptionalDynamic optionalBlockEntityTag = componentData.get(WWConstants.vanillaId("block_entity_data").toString());
        if (optionalBlockEntityTag.result().isEmpty()) {
            return componentData;
        }
        Dynamic blockEntityTag = (Dynamic)optionalBlockEntityTag.result().get();
        componentData = componentData.set(WWConstants.string("fireflies"), DisplayLanternItemComponentizationFix.fixOccupants(blockEntityTag));
        blockEntityTag = blockEntityTag.remove("Fireflies");
        componentData = componentData.set(WWConstants.vanillaId("block_entity_data").toString(), blockEntityTag);
        return componentData;
    }
}

