/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinAi;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.tag.WWItemTags;
import net.minecraft.class_10209;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1332;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5757;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Penguin
extends class_1429 {
    private static final List<String> VALID_LINUX_NAMES = ImmutableList.of((Object)"Linux", (Object)"Tux", (Object)"Treetrain", (Object)"Treetrain1");
    public static final double BOAT_BOOST_SPEED = 1.7;
    public class_7094 layDownAnimationState = new class_7094();
    public class_7094 standUpAnimationState = new class_7094();
    public class_7094 callAnimationState = new class_7094();
    private float prevWadeProgress;
    private float wadeProgress;
    private float prevSlideProgress;
    private float slideProgress;

    public Penguin(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_5757((class_1308)this, 85, 30, 0.4f, 0.2f, true);
        this.field_6206 = new class_1332((class_1308)this, 20);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_4095.class_5303<Penguin> method_28306() {
        return PenguinAi.brainProvider();
    }

    @NotNull
    public class_4095<Penguin> method_18868() {
        return super.method_18868();
    }

    @NotNull
    public class_4095<Penguin> method_18867(@NotNull Dynamic<?> dynamic) {
        return PenguinAi.makeBrain(this, (class_4095<Penguin>)this.method_28306().method_28335(dynamic));
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_49079, 5.0).method_26868(class_5134.field_51578, 0.5);
    }

    public static boolean checkPenguinSpawnRules(class_1299<? extends Penguin> entityType, class_1936 level, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (!WWEntityConfig.get().penguin.spawnPenguins) {
            return false;
        }
        return level.method_8320(pos.method_10074()).method_26164(WWBlockTags.PENGUINS_SPAWNABLE_ON) && Penguin.method_39448((class_1920)level, (class_2338)pos);
    }

    @NotNull
    protected class_1408 method_5965(class_1937 level) {
        return new class_5766((class_1308)this, level);
    }

    public void method_5790() {
        if (this.method_5681()) {
            this.method_5796(this.method_5799() && !this.method_5765());
        } else {
            this.method_5796(this.method_5869() && !this.method_5765() && this.method_73183().method_8316(this.method_24515()).method_15767(class_3486.field_15517));
        }
    }

    public void method_5796(boolean bl) {
        super.method_5796(bl);
        if (bl) {
            this.method_18380(class_4050.field_18076);
        }
    }

    public void method_29242(boolean includeHeight) {
        super.method_29242(this.method_5681() || includeHeight);
    }

    public boolean method_20232() {
        return this.method_5681() && this.method_5869();
    }

    public boolean isTouchingWaterOrSwimming() {
        return this.method_5799() || this.method_20232();
    }

    public boolean method_6481(@NotNull class_1799 itemStack) {
        return itemStack.method_31573(WWItemTags.PENGUIN_FOOD);
    }

    public boolean hasAttackTarget() {
        return this.method_18868().method_18896(class_4140.field_22355);
    }

    public void method_24650(@NotNull class_3218 level, @NotNull class_1429 mate) {
        this.method_49794(level, mate, null);
        this.method_18868().method_18878(class_4140.field_37443, (Object)class_3902.field_17274);
    }

    public boolean isPregnant() {
        return this.method_18868().method_18896(class_4140.field_37443);
    }

    public void revokePregnancy() {
        this.method_18868().method_18875(class_4140.field_37443);
    }

    @Nullable
    public Penguin getBreedOffspring(@NotNull class_3218 level, @NotNull class_1296 otherParent) {
        return (Penguin)WWEntityTypes.PENGUIN.method_5883((class_1937)level, class_3730.field_16466);
    }

    public void method_5773() {
        super.method_5773();
        this.prevWadeProgress = this.wadeProgress;
        this.wadeProgress += ((this.isTouchingWaterOrSwimming() && !this.method_5869() ? 1.0f : 0.0f) - this.wadeProgress) * 0.175f;
        this.prevSlideProgress = this.slideProgress;
        this.slideProgress += ((this.method_41328(class_4050.field_47246) ? 1.0f : 0.0f) - this.slideProgress) * 0.175f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_73183() != livingEntity.method_73183()) return false;
        if (this.method_73183().method_8407().equals((Object)class_1267.field_5801)) return false;
        if (!class_1301.field_6156.test(livingEntity)) return false;
        if (this.method_5722((class_1297)livingEntity)) return false;
        if (livingEntity.method_5864() == class_1299.field_6131) return false;
        if (livingEntity.method_5864() == WWEntityTypes.PENGUIN) return false;
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (livingEntity.method_31481()) return false;
        if (!this.method_73183().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    public boolean method_5874(class_3218 serverLevel, class_1309 livingEntity, class_1282 source) {
        boolean killed = super.method_5874(serverLevel, livingEntity, source);
        if (this.method_18868().method_18906(class_4168.field_22396)) {
            PenguinAi.addCallMemoryIfPenguinsClose(this);
        }
        return killed;
    }

    public float getWadeProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevWadeProgress, (float)this.wadeProgress);
    }

    public float getSlideProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevSlideProgress, (float)this.slideProgress);
    }

    public boolean isSlidingOrSwimming() {
        return this.isSliding() || this.method_5681();
    }

    public boolean isSliding() {
        return this.method_41328(class_4050.field_47246);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (field_18064.equals(entityDataAccessor)) {
            switch (this.method_18376()) {
                case field_47246: {
                    this.layDownAnimationState.method_41322(this.field_6012);
                    this.standUpAnimationState.method_41325();
                    this.callAnimationState.method_41325();
                    break;
                }
                case field_38099: {
                    this.standUpAnimationState.method_41322(this.field_6012);
                    this.layDownAnimationState.method_41325();
                    this.callAnimationState.method_41325();
                    break;
                }
                case field_38097: {
                    this.callAnimationState.method_41322(this.field_6012);
                    this.standUpAnimationState.method_41325();
                    this.layDownAnimationState.method_41325();
                    break;
                }
                default: {
                    this.standUpAnimationState.method_41325();
                    this.layDownAnimationState.method_41325();
                    this.callAnimationState.method_41325();
                }
            }
            this.method_18382();
        }
        super.method_5674(entityDataAccessor);
    }

    @NotNull
    public class_4048 method_55694(class_4050 pose) {
        class_4048 entityDimensions = super.method_55694(pose);
        return this.isSliding() ? class_4048.method_18385((float)entityDimensions.comp_2185(), (float)0.5f) : entityDimensions;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.isLinux() ? WWSounds.ENTITY_LINUX_IDLE : WWSounds.ENTITY_PENGUIN_IDLE;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return this.isLinux() ? WWSounds.ENTITY_LINUX_HURT : WWSounds.ENTITY_PENGUIN_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return this.isLinux() ? WWSounds.ENTITY_LINUX_DEATH : WWSounds.ENTITY_PENGUIN_DEATH;
    }

    public int method_5970() {
        return 200;
    }

    protected float method_5867() {
        if (this.isSliding()) {
            return super.method_5867();
        }
        if (this.method_5681()) {
            return this.field_5994 + 1.0f;
        }
        return this.field_5994 + 0.4f;
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        if (!this.isSliding()) {
            this.method_5783(this.isLinux() ? WWSounds.ENTITY_LINUX_STEP : WWSounds.ENTITY_PENGUIN_STEP, 0.1f, 1.0f);
            return;
        }
        super.method_5712(pos, state);
    }

    protected void method_5958(@NotNull class_3218 serverLevel) {
        class_3695 profilerFiller = class_10209.method_64146();
        profilerFiller.method_15396("penguinBrain");
        this.method_18868().method_19542(serverLevel, (class_1309)this);
        profilerFiller.method_15407();
        profilerFiller.method_15396("penguinActivityUpdate");
        PenguinAi.updateActivity(this);
        profilerFiller.method_15407();
        super.method_5958(serverLevel);
    }

    public void method_5652(@NotNull class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71469("EntityPose", this.method_18376().name());
    }

    public void method_5749(@NotNull class_11368 valueInput) {
        super.method_5749(valueInput);
        valueInput.method_71441("EntityPose").ifPresent(entityPose -> {
            if (Arrays.stream(class_4050.values()).anyMatch(pose -> pose.name().equals(entityPose))) {
                this.method_18380(class_4050.valueOf((String)entityPose));
            }
        });
    }

    public boolean isLinux() {
        String string = class_124.method_539((String)this.method_5477().getString());
        return VALID_LINUX_NAMES.stream().anyMatch(string::equalsIgnoreCase);
    }
}

