/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ServerLevelWrapper
implements IServerLevelWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Map<ServerLevel, WeakReference<ServerLevelWrapper>> LEVEL_WRAPPER_REF_BY_SERVER_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private final ServerLevel level;
    private IDhLevel dhLevel;
    private final String KeyedLevelDimensionName;

    public static ServerLevelWrapper getWrapper(ServerLevel level) {
        return (ServerLevelWrapper)LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.compute(level, (newLevel, levelRef) -> {
            ServerLevelWrapper oldLevelWrapper;
            if (levelRef != null && (oldLevelWrapper = (ServerLevelWrapper)levelRef.get()) != null) {
                return levelRef;
            }
            return new WeakReference<ServerLevelWrapper>(new ServerLevelWrapper((ServerLevel)newLevel));
        }).get();
    }

    public ServerLevelWrapper(ServerLevel level) {
        this.level = level;
        this.KeyedLevelDimensionName = this.createKeyedLevelDimensionName();
    }

    @Override
    public File getMcSaveFolder() {
        return this.level.getChunkSource().getDataStorage().dataFolder.toFile();
    }

    @Override
    public String getKeyedLevelDimensionName() {
        return this.KeyedLevelDimensionName;
    }

    private String createKeyedLevelDimensionName() {
        String dimensionName = this.getDhIdentifier();
        if (Config.Server.sendLevelKeys.get().booleanValue()) {
            Object levelKeyPrefix = Config.Server.levelKeyPrefix.get();
            if (SharedApi.getEnvironment() == EWorldEnvironment.CLIENT_SERVER) {
                String cleanWorldFolderName = this.getWorldFolderName().replaceAll("[^a-zA-Z0-9-_ ]", "").replaceAll(" ", "_");
                levelKeyPrefix = (String)levelKeyPrefix + (!((String)levelKeyPrefix).isEmpty() ? "_" : "") + cleanWorldFolderName + "_" + this.getHashedSeedEncoded();
            }
            if (((String)levelKeyPrefix).isEmpty()) {
                levelKeyPrefix = this.getHashedSeedEncoded();
            }
            String mainPart = "@" + dimensionName;
            return ((String)levelKeyPrefix).substring(0, Math.min(150 - mainPart.length(), ((String)levelKeyPrefix).length())) + mainPart;
        }
        return dimensionName;
    }

    private String getWorldFolderName() {
        try {
            return this.level.getServer().getLevel((ResourceKey)Level.OVERWORLD).getChunkSource().getDataStorage().dataFolder.getParent().getFileName().toString();
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get world folder name. LODs may not load or save correctly. Error: [" + e.getMessage() + "].", e);
            return "unknown_world";
        }
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.dimensionType());
    }

    @Override
    public String getDimensionName() {
        return this.level.dimension().location().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.getBiomeManager().biomeZoomSeed;
    }

    @Override
    public String getDhIdentifier() {
        return this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.SERVER_LEVEL;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.dimensionType().hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.dimensionType().hasSkyLight();
    }

    @Override
    public int getMaxHeight() {
        return this.level.getHeight();
    }

    @Override
    public int getMinHeight() {
        return this.level.getMinY();
    }

    public ServerLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.remove(this.level);
    }

    @Override
    public void setDhLevel(IDhLevel dhLevel) {
        this.dhLevel = dhLevel;
    }

    @Override
    @Nullable
    public IDhLevel getDhLevel() {
        return this.dhLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getGenericRenderer();
    }

    @Override
    public File getDhSaveFolder() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getSaveStructure().getSaveFolder(this);
    }

    public String toString() {
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

