/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.lang;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.file.FileConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.json.JsonFormat;
import dev.kostromdan.mods.crash_assistant.nightconfig.toml.TomlFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lang {
    public HashMap<String, String> lang;
    public static FileConfig BCCConfig;
    private static final Map<String, Function<String, String>> TEXT_TRANSFORMS;

    public static void registerTextTransform(String tagName, Function<String, String> transformer) {
        if (tagName == null || tagName.isEmpty() || transformer == null) {
            return;
        }
        TEXT_TRANSFORMS.put(tagName, transformer);
    }

    public Lang(HashMap<String, String> lang) {
        this.lang = lang;
    }

    public String get(String key) {
        return this.get(key, new HashMap<String, String>());
    }

    public String get(String key, HashMap<String, String> placeHoldersSurroundedWithHref) {
        String value = this.lang.getOrDefault(key, LanguageProvider.languages.get((Object)"en_us").lang.get(key));
        if (value == null) {
            throw new NullPointerException("Seems like key '" + key + "' is missing in language files");
        }
        return Lang.applyPlaceHolders(value, placeHoldersSurroundedWithHref);
    }

    public static String applyPlaceHolders(String value, HashMap<String, String> placeHoldersSurroundedWithHref) {
        if (!value.contains("$")) {
            return value;
        }
        value = Lang.applyPlaceHolder("$CONFIG.", value, CrashAssistantConfig::get, placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$LANG.", value, key -> LanguageProvider.get(key, placeHoldersSurroundedWithHref), placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$MSG_LANG.", value, LanguageProvider::getMsgLang, placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$BCC.", value, Lang::getBCCValue, placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$LINK.", value, LinksProvider::getLinkByKey, placeHoldersSurroundedWithHref);
        value = Lang.applyTextTransforms(value);
        return value;
    }

    private static String applyPlaceHolder(String placeHolderStart, String value, Function<String, String> configGetFunction, HashMap<String, String> placeHoldersSurroundedWithHref) {
        while (value.contains(placeHolderStart)) {
            int placeHolderStartLength = placeHolderStart.length();
            int placeHolderStartIndex = value.indexOf(placeHolderStart);
            int placeHolderEndIndex = value.indexOf("$", placeHolderStartIndex + placeHolderStartLength) + 1;
            String placeholder = value.substring(placeHolderStartIndex, placeHolderEndIndex);
            String configKey = placeholder.substring(placeHolderStartLength, placeholder.length() - 1);
            Object configValue = placeHolderStart.equals("$CONFIG.") && (configKey.equals("text.support_place") || configKey.equals("text.support_name")) ? (configKey.equals("text.support_place") ? PlatformHelp.getActualHelpChannel() : PlatformHelp.getActualHelpName()) : configGetFunction.apply(configKey);
            if (placeHoldersSurroundedWithHref.containsKey(placeholder) || placeHolderStart.equals("$LINK.")) {
                String placeHolderValue = placeHoldersSurroundedWithHref.get(placeholder);
                configValue = placeHolderValue == null ? (placeHolderStart.equals("$LINK.") ? "<a href='" + (String)configValue + "'>" + (String)configValue + "</a>" : "<a href='" + placeholder.substring(1, placeholder.length() - 1) + "'>" + (String)configValue + "</a>") : "<a href='" + (String)configValue + "'>" + placeHolderValue + "</a>";
            }
            value = value.replaceAll(Pattern.quote(placeholder), Matcher.quoteReplacement((String)configValue));
        }
        return value;
    }

    public static String getBCCValue(String key) {
        Path BCCConfigForgePath = Paths.get("config", "bcc-common.toml");
        Path BCCConfigFabricPath = Paths.get("config", "bcc.json");
        try {
            if (BCCConfig == null) {
                if (!Files.exists(BCCConfigForgePath, new LinkOption[0]) && !Files.exists(BCCConfigFabricPath, new LinkOption[0])) {
                    JarInJarHelper.LOGGER.error("BCC config file not found");
                    return "<BCC config file not found>";
                }
                boolean forge = BCCConfigForgePath.toFile().exists();
                BCCConfig = FileConfig.builder(forge ? BCCConfigForgePath : BCCConfigFabricPath, forge ? TomlFormat.instance() : JsonFormat.fancyInstance()).build();
                BCCConfig.load();
            }
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.error("Failed to load BCC config:", (Throwable)e);
            BCCConfig = null;
            return "<BCC config parsing error>";
        }
        key = BCCConfigForgePath.toFile().exists() ? "general." + (String)key : key;
        String value = (String)BCCConfig.get((String)key);
        if (value == null) {
            return "<" + (String)key + " not found in BCC config>";
        }
        return value;
    }

    private static String applyTextTransforms(String input) {
        TagHit next;
        if (input == null || input.isEmpty() || TEXT_TRANSFORMS.isEmpty()) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input);
        while ((next = Lang.findNextOpeningTag(sb, 0)) != null) {
            int removeEnd;
            int contentEnd;
            String closeMarker = next.closeMarker;
            int openStart = next.openIndex;
            String openMarker = next.openMarker;
            int contentStart = openStart + openMarker.length();
            int closeStart = Lang.indexOf(sb, closeMarker, contentStart);
            if (closeStart >= 0) {
                contentEnd = closeStart;
                removeEnd = closeStart + closeMarker.length();
            } else {
                contentEnd = sb.length();
                removeEnd = sb.length();
            }
            String inner = sb.substring(contentStart, contentEnd);
            Function<String, String> fn = TEXT_TRANSFORMS.get(next.tagName);
            String transformed = fn != null ? fn.apply(inner) : inner;
            sb.replace(openStart, removeEnd, transformed);
        }
        return sb.toString();
    }

    private static TagHit findNextOpeningTag(CharSequence text, int fromIndex) {
        int bestIndex = -1;
        TagHit best = null;
        for (String tagName : TEXT_TRANSFORMS.keySet()) {
            String open = "<" + tagName + ">";
            String close = "</" + tagName + ">";
            int at = Lang.indexOf(text, open, fromIndex);
            if (at < 0 || bestIndex != -1 && at >= bestIndex) continue;
            bestIndex = at;
            best = new TagHit(tagName, open, close, at);
        }
        return best;
    }

    private static int indexOf(CharSequence cs, String needle, int fromIndex) {
        if (cs instanceof StringBuilder) {
            return ((StringBuilder)cs).indexOf(needle, fromIndex);
        }
        String hay = cs.toString();
        return hay.indexOf(needle, fromIndex);
    }

    static {
        TEXT_TRANSFORMS = new LinkedHashMap<String, Function<String, String>>();
        Lang.registerTextTransform("TOLOWER", s -> s.toLowerCase(Locale.ROOT));
    }

    private static class TagHit {
        final String tagName;
        final String openMarker;
        final String closeMarker;
        final int openIndex;

        TagHit(String tagName, String openMarker, String closeMarker, int openIndex) {
            this.tagName = tagName;
            this.openMarker = openMarker;
            this.closeMarker = closeMarker;
            this.openIndex = openIndex;
        }
    }
}

