/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.fabric.entrypoint;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.ArgUtils;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ClassExistenceChecker;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.LanguageAdapterException;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashAssistantLanguageAdapter
implements LanguageAdapter {
    private static final Logger LOGGER = LogManager.getLogger((String)"CrashAssistantLanguageAdapter");

    public CrashAssistantLanguageAdapter() {
        if (Boolean.getBoolean("dev.kostromdan.mods.crash_assistant.startedFlag")) {
            return;
        }
        System.setProperty("dev.kostromdan.mods.crash_assistant.startedFlag", "true");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List<URL> requiredJarUrls = CrashAssistantLanguageAdapter.findRequiredLibrariesOnClasspath();
            if (requiredJarUrls.isEmpty()) {
                throw new RuntimeException("Could not find required libraries (commons-io, oshi-core, jna) on the classpath.");
            }
            ParentLastURLClassLoader customLoader = new ParentLastURLClassLoader(requiredJarUrls.toArray(new URL[0]), CrashAssistantLanguageAdapter.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(customLoader);
            Class<?> runnerClass = customLoader.loadClass(SetupRunner.class.getName());
            Runnable runner = (Runnable)runnerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            runner.run();
        }
        catch (Throwable throwable) {
            LOGGER.error("A critical error occurred during Crash Assistant setup:", throwable);
            throw new RuntimeException(throwable);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static List<URL> findRequiredLibrariesOnClasspath() {
        String[] paths;
        HashSet<URL> foundUrls = new HashSet<URL>();
        String classPath = System.getProperty("java.class.path");
        String separator = File.pathSeparator;
        for (String pathStr : paths = classPath.split(separator)) {
            if (!pathStr.contains("commons-io") && !pathStr.contains("oshi-core") && !pathStr.contains("jna-") && !pathStr.contains("platform-")) continue;
            try {
                URL url = Paths.get(pathStr, new String[0]).toUri().toURL();
                foundUrls.add(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            CodeSource codeSource = CrashAssistantLanguageAdapter.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL modJarUrl = codeSource.getLocation();
                foundUrls.add(modJarUrl);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not determine location of CrashAssistant JAR", (Throwable)e);
        }
        return new ArrayList<URL>(foundUrls);
    }

    public <T> T create(ModContainer mod, String value, Class<T> type) throws LanguageAdapterException {
        throw new IllegalStateException();
    }

    private static class ParentLastURLClassLoader
    extends URLClassLoader {
        public ParentLastURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    if (name.startsWith("dev.kostromdan.mods.crash_assistant.common_config.platform")) {
                        c = this.getParent().loadClass(name);
                    } else {
                        try {
                            c = this.findClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            c = this.getParent().loadClass(name);
                        }
                    }
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> localResources = this.findResources(name);
            if (localResources.hasMoreElements()) {
                return localResources;
            }
            return this.getParent().getResources(name);
        }
    }

    public static class SetupRunner
    implements Runnable {
        @Override
        public void run() {
            String launchTarget = FabricLoader.getInstance().getEnvironmentType().toString();
            ArgUtils.setLaunchArgs(FabricLoader.getInstance().getLaunchArguments(false));
            FabricLoader.getInstance().getModContainer("minecraft").ifPresent(container -> {
                PlatformHelp.minecraftVersion = container.getMetadata().getVersion().getFriendlyString();
            });
            if (ClassExistenceChecker.classExists("org.sinytra.connector.loader.ConnectorEarlyLoader") || ClassExistenceChecker.classExists("org.sinytra.connector.ConnectorEarlyLoader")) {
                PlatformHelp.modLoadedWithConnector = true;
                LOGGER.warn("Seems like you using fabric version of Crash Assistant on forge/neoforge with help of Sinytra Connector. It not known to cause issues (except gui won't display on some very early crashes), but not recommended, since native mod version for forge/neoforge exists.");
                PlatformHelp.platform = FabricLoader.getInstance().isModLoaded("neoforge") ? PlatformHelp.NEOFORGE : PlatformHelp.FORGE;
            } else {
                PlatformHelp.platform = FabricLoader.getInstance().isModLoaded("quilt_loader") ? PlatformHelp.QUILT : PlatformHelp.FABRIC;
            }
            if (PlatformHelp.modLoadedWithConnector) {
                try {
                    if (PlatformHelp.platform == PlatformHelp.NEOFORGE) {
                        Class<?> fmlLoaderClass = Class.forName("net.neoforged.fml.loading.FMLLoader");
                        Object versionInfo = fmlLoaderClass.getMethod("versionInfo", new Class[0]).invoke(null, new Object[0]);
                        String neoForgeVersion = (String)versionInfo.getClass().getMethod("neoForgeVersion", new Class[0]).invoke(versionInfo, new Object[0]);
                        LibrariesJarLocator.setupLoaderJarName("neoforge-" + neoForgeVersion);
                    } else if (PlatformHelp.platform == PlatformHelp.FORGE) {
                        Class<?> versionInfoClass = Class.forName("net.minecraftforge.fml.loading.VersionInfo");
                        LibrariesJarLocator.setupLoaderJarName(versionInfoClass);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to setup loader jar name via reflection for Connector environment", (Throwable)e);
                }
            } else {
                LibrariesJarLocator.setupLoaderJarName(FabricLoader.class);
            }
            JarInJarHelper.launchCrashAssistantApp(launchTarget);
        }
    }
}

