/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.ITooltipProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TSelectEnumWidget<E extends Enum<E>>
extends TSelectWidget<EnumEntry<E>> {
    protected final Class<E> enumType;

    public TSelectEnumWidget(int x, int y, int width, int height, E enumValue) {
        this(x, y, width, height, ((Enum)Objects.requireNonNull(enumValue)).getDeclaringClass(), DEFAULT_LABEL);
        this.setSelected(enumValue);
    }

    public TSelectEnumWidget(int x, int y, int width, int height, Class<E> enumType) {
        this(x, y, width, height, enumType, DEFAULT_LABEL);
    }

    public TSelectEnumWidget(int x, int y, int width, int height, Class<E> enumType, class_2561 text) {
        super(x, y, width, height, text, (TSelectWidget.Entry[])new EnumEntry[0]);
        this.enumType = Objects.requireNonNull(enumType);
        if (!this.enumType.isEnum()) {
            throw new IllegalArgumentException("Illegal " + Enum.class.getSimpleName() + " type. " + enumType.getName() + " is not an " + Enum.class.getSimpleName() + ".");
        }
        for (Enum enumValue : (Enum[])this.enumType.getEnumConstants()) {
            this.addEntry(new EnumEntry<Enum>(enumValue));
        }
    }

    public final Class<E> getEnumType() {
        return this.enumType;
    }

    @Nullable
    public final EnumEntry<E> entryOf(E enumValue) {
        return this.entries.find(e -> e.enumValue == enumValue);
    }

    @Override
    public final void setSelected(E enumValue) throws NoSuchElementException {
        EnumEntry<E> e = this.entryOf(enumValue);
        if (e == null && enumValue != null) {
            throw new NoSuchElementException();
        }
        this.setSelected((E)e);
    }

    public static final class EnumEntry<E extends Enum<E>>
    implements TSelectWidget.Entry {
        protected final E enumValue;
        protected final class_2561 enumText;
        @Nullable
        protected final class_7919 tooltip;

        public EnumEntry(E enumValue) {
            this.enumValue = (Enum)Objects.requireNonNull(enumValue);
            this.enumText = enumValue instanceof ITextProvider ? ((ITextProvider)enumValue).getText() : TextUtils.literal(((Enum)enumValue).name());
            this.tooltip = enumValue instanceof ITooltipProvider ? ((ITooltipProvider)enumValue).getTooltip() : null;
        }

        public E getEnumValue() {
            return this.enumValue;
        }

        @Override
        public final class_2561 getText() {
            return this.enumText;
        }

        @Override
        @Nullable
        public final class_7919 getTooltip() {
            return this.tooltip;
        }

        @Override
        @Nullable
        public final Runnable getOnSelect() {
            return null;
        }
    }
}

