/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.ISubSettingsManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.class_1074;

public class PersistentMapSettingsManager
implements ISubSettingsManager {
    protected int mapX;
    protected int mapZ;
    protected float zoom = 4.0f;
    private float minZoomPower = -1.0f;
    private float maxZoomPower = 4.0f;
    protected float minZoom = 0.5f;
    protected float maxZoom = 16.0f;
    protected int cacheSize = 500;
    protected boolean outputImages;
    public boolean showWaypoints = true;
    public boolean showWaypointNames = true;

    @Override
    public void loadSettings(File settingsFile) {
        try {
            String sCurrentLine;
            BufferedReader in = new BufferedReader(new FileReader(settingsFile));
            while ((sCurrentLine = in.readLine()) != null) {
                String[] curLine = sCurrentLine.split(":");
                switch (curLine[0]) {
                    case "Worldmap Zoom": {
                        this.zoom = Float.parseFloat(curLine[1]);
                        break;
                    }
                    case "Worldmap Minimum Zoom": {
                        this.minZoom = Float.parseFloat(curLine[1]);
                        break;
                    }
                    case "Worldmap Maximum Zoom": {
                        this.maxZoom = Float.parseFloat(curLine[1]);
                        break;
                    }
                    case "Worldmap Cache Size": {
                        this.cacheSize = Integer.parseInt(curLine[1]);
                        break;
                    }
                    case "Show Worldmap Waypoints": {
                        this.showWaypoints = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Worldmap Waypoint Names": {
                        this.showWaypointNames = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Output Images": {
                        this.outputImages = Boolean.parseBoolean(curLine[1]);
                    }
                }
            }
            in.close();
        }
        catch (IOException in) {
            // empty catch block
        }
        for (int power = -3; power <= 5; ++power) {
            if (Math.pow(2.0, power) == (double)this.minZoom) {
                this.minZoomPower = power;
            }
            if (Math.pow(2.0, power) != (double)this.maxZoom) continue;
            this.maxZoomPower = power;
        }
        this.bindCacheSize();
        this.bindZoom();
    }

    @Override
    public void saveAll(PrintWriter out) {
        out.println("Worldmap Zoom:" + this.zoom);
        out.println("Worldmap Minimum Zoom:" + this.minZoom);
        out.println("Worldmap Maximum Zoom:" + this.maxZoom);
        out.println("Worldmap Cache Size:" + this.cacheSize);
        out.println("Show Worldmap Waypoints:" + this.showWaypoints);
        out.println("Show Worldmap Waypoint Names:" + this.showWaypointNames);
    }

    @Override
    public String getKeyText(EnumOptionsMinimap options) {
        String s = class_1074.method_4662((String)options.getName(), (Object[])new Object[0]) + ": ";
        if (options.isFloat()) {
            float f = this.getOptionFloatValue(options);
            if (options == EnumOptionsMinimap.MIN_ZOOM) {
                return s + (float)Math.pow(2.0, f) + "x";
            }
            if (options == EnumOptionsMinimap.MAX_ZOOM) {
                return s + (float)Math.pow(2.0, f) + "x";
            }
            if (options == EnumOptionsMinimap.CACHE_SIZE) {
                return s + (int)f;
            }
        }
        if (options.isBoolean()) {
            boolean flag = this.getOptionBooleanValue(options);
            return flag ? s + class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : s + class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
        }
        return s;
    }

    @Override
    public float getOptionFloatValue(EnumOptionsMinimap options) {
        if (options == EnumOptionsMinimap.MIN_ZOOM) {
            return this.minZoomPower;
        }
        if (options == EnumOptionsMinimap.MAX_ZOOM) {
            return this.maxZoomPower;
        }
        return options == EnumOptionsMinimap.CACHE_SIZE ? (float)this.cacheSize : 0.0f;
    }

    public boolean getOptionBooleanValue(EnumOptionsMinimap par1EnumOptions) {
        return switch (par1EnumOptions) {
            case EnumOptionsMinimap.SHOW_WAYPOINTS -> {
                if (this.showWaypoints && VoxelMap.mapOptions.waypointsAllowed) {
                    yield true;
                }
                yield false;
            }
            case EnumOptionsMinimap.SHOW_WAYPOINT_NAMES -> {
                if (this.showWaypointNames && VoxelMap.mapOptions.waypointsAllowed) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a boolean)");
        };
    }

    @Override
    public void setOptionFloatValue(EnumOptionsMinimap options, float value) {
        if (options == EnumOptionsMinimap.MIN_ZOOM) {
            this.minZoomPower = (int)(value * 8.0f) - 3;
            this.minZoom = (float)Math.pow(2.0, this.minZoomPower);
            if (this.maxZoom < this.minZoom) {
                this.maxZoom = this.minZoom;
                this.maxZoomPower = this.minZoomPower;
            }
        } else if (options == EnumOptionsMinimap.MAX_ZOOM) {
            this.maxZoomPower = (int)(value * 8.0f) - 3;
            this.maxZoom = (float)Math.pow(2.0, this.maxZoomPower);
            if (this.minZoom > this.maxZoom) {
                this.minZoom = this.maxZoom;
                this.minZoomPower = this.maxZoomPower;
            }
        } else if (options == EnumOptionsMinimap.CACHE_SIZE) {
            this.cacheSize = (int)(value * 5000.0f);
            this.cacheSize = Math.max(this.cacheSize, 30);
            int minCacheSize = (int)((1600.0f / this.minZoom / 256.0f + 4.0f) * (1100.0f / this.minZoom / 256.0f + 3.0f) * 1.35f);
            while (this.cacheSize < minCacheSize) {
                this.minZoomPower += 1.0f;
                this.minZoom = (float)Math.pow(2.0, this.minZoomPower);
                minCacheSize = (int)((1600.0f / this.minZoom / 256.0f + 4.0f) * (1100.0f / this.minZoom / 256.0f + 3.0f) * 1.35f);
            }
            if (this.maxZoom < this.minZoom) {
                this.maxZoom = this.minZoom;
                this.maxZoomPower = this.minZoomPower;
            }
        }
        this.bindZoom();
        this.bindCacheSize();
    }

    public void setOptionValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case SHOW_WAYPOINTS: {
                this.showWaypoints = !this.showWaypoints;
                break;
            }
            case SHOW_WAYPOINT_NAMES: {
                this.showWaypointNames = !this.showWaypointNames;
                break;
            }
            default: {
                throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName());
            }
        }
    }

    private void bindCacheSize() {
        int minCacheSize = (int)((1600.0f / this.minZoom / 256.0f + 4.0f) * (1100.0f / this.minZoom / 256.0f + 3.0f) * 1.35f);
        this.cacheSize = Math.max(this.cacheSize, minCacheSize);
    }

    private void bindZoom() {
        this.zoom = Math.max(this.zoom, this.minZoom);
        this.zoom = Math.min(this.zoom, this.maxZoom);
    }
}

