/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import net.minecraft.class_310;
import net.minecraft.class_9848;

public class CPULightmap {
    private static final CPULightmap INSTANCE = new CPULightmap();
    private static final class_310 MINECRAFT = class_310.method_1551();
    private float blockLightRedFlicker = 0.0f;
    private float AmbientLightFactor = 0.0f;
    private float SkyFactor = 0.0f;
    private float BlockFactor = 0.0f;
    private float SkyLightColorR = 1.0f;
    private float SkyLightColorG = 1.0f;
    private float SkyLightColorB = 1.0f;
    private float BrightnessFactor = 0.0f;

    public static CPULightmap getInstance() {
        return INSTANCE;
    }

    float mix(float v1, float v2, float mix) {
        return v1 * (1.0f - mix) + v2 * mix;
    }

    float get_brightness(float level) {
        float curved_level = level / (4.0f - 3.0f * level);
        return this.mix(curved_level, 1.0f, this.AmbientLightFactor);
    }

    float notGamma(float x) {
        float nx = 1.0f - x;
        return 1.0f - nx * nx * nx * nx;
    }

    public void setup() {
        float h;
        this.AmbientLightFactor = CPULightmap.MINECRAFT.field_1687.method_8597().comp_656();
        float g = CPULightmap.MINECRAFT.field_1687.method_23783(1.0f);
        this.SkyFactor = h = g * 0.95f + 0.05f;
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.BlockFactor = this.blockLightRedFlicker + 1.5f;
        this.SkyLightColorR = g * 0.65f + 0.35f;
        this.SkyLightColorG = g * 0.65f + 0.35f;
        this.SkyLightColorB = 1.0f;
        float p = ((Double)CPULightmap.MINECRAFT.field_1690.method_42473().method_41753()).floatValue();
        this.BrightnessFactor = Math.max(0.0f, p);
    }

    public int getLight(int blockLight, int skyLight) {
        float block_brightness = this.get_brightness((float)blockLight / 15.0f) * this.BlockFactor;
        float sky_brightness = this.get_brightness((float)skyLight / 15.0f) * this.SkyFactor;
        float colorr = block_brightness;
        float colorg = block_brightness * ((block_brightness * 0.6f + 0.4f) * 0.6f + 0.4f);
        float colorb = block_brightness * (block_brightness * block_brightness * 0.6f + 0.4f);
        colorr += this.SkyLightColorR * sky_brightness;
        colorg += this.SkyLightColorG * sky_brightness;
        colorb += this.SkyLightColorB * sky_brightness;
        colorr = Math.max(Math.min(colorr, 1.0f), 0.0f);
        colorg = Math.max(Math.min(colorg, 1.0f), 0.0f);
        colorb = Math.max(Math.min(colorb, 1.0f), 0.0f);
        colorr = this.mix(colorr, this.notGamma(colorr), this.BrightnessFactor);
        colorg = this.mix(colorg, this.notGamma(colorg), this.BrightnessFactor);
        colorb = this.mix(colorb, this.notGamma(colorb), this.BrightnessFactor);
        colorr = this.mix(colorr, 0.75f, 0.04f);
        colorg = this.mix(colorg, 0.75f, 0.04f);
        colorb = this.mix(colorb, 0.75f, 0.04f);
        colorr = this.mix(colorr, 1.0f, 0.1f);
        colorg = this.mix(colorg, 1.0f, 0.1f);
        colorb = this.mix(colorb, 1.0f, 0.1f);
        colorr = Math.min(colorr, 1.0f);
        colorg = Math.min(colorg, 1.0f);
        colorb = Math.min(colorb, 1.0f);
        return class_9848.method_61318((float)1.0f, (float)colorb, (float)colorg, (float)colorr);
    }
}

