/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.lang.reflect.Field;
import java.util.ArrayList;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object getPrivateFieldValueByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype) {
        return ReflectionUtils.getPrivateFieldValueByType(o, objectClasstype, fieldClasstype, 0);
    }

    public static Object getPrivateFieldValueByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype, int index) {
        Field[] fields;
        Class<?> objectClass = o != null ? o.getClass() : objectClasstype;
        while (!objectClass.equals(objectClasstype) && objectClass.getSuperclass() != null) {
            objectClass = objectClass.getSuperclass();
        }
        int counter = 0;
        for (Field field : fields = objectClass.getDeclaredFields()) {
            if (!fieldClasstype.equals(field.getType())) continue;
            if (counter == index) {
                try {
                    field.setAccessible(true);
                    return field.get(o);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++counter;
        }
        return null;
    }

    public static ArrayList<Field> getFieldsByType(Object o, Class<?> objectClassBaseType, Class<?> fieldClasstype) {
        ArrayList<Field> matches = new ArrayList<Field>();
        Class<?> objectClass = o.getClass();
        while (!objectClass.equals(objectClassBaseType) && objectClass.getSuperclass() != null) {
            Field[] fields;
            for (Field field : fields = objectClass.getDeclaredFields()) {
                if (!fieldClasstype.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                matches.add(field);
            }
            objectClass = objectClass.getSuperclass();
        }
        return matches;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException var2) {
            return false;
        }
    }
}

