/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.class_loading;

import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ErrorUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Boot {
    public static String classPath = null;
    public static String crashAssistantModJarName = null;
    public static boolean recursiveStart = false;
    public static boolean gpuDetect = false;
    public static boolean vulkanAddonLoaded = false;
    public static String serialisedGPUs = null;
    public static long parentPID = -1L;
    public static long parentStarted = -1L;
    public static List<String> JVM_ARGS = ManagementFactory.getRuntimeMXBean().getInputArguments();
    public static List<String> APP_ARGS;
    public static String MINECRAFT_LAUNCH_COMMAND;
    public static String MINECRAFT_JVM_ARGS;

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        try {
            int i;
            ArrayList<String> effectiveArgs = new ArrayList<String>();
            String argsFilePath = null;
            for (i = 0; i < args.length; ++i) {
                if ("--args-file".equals(args[i]) && i + 1 < args.length) {
                    argsFilePath = args[i + 1];
                    Path argsFile = Paths.get(argsFilePath, new String[0]);
                    if (!Files.exists(argsFile, new LinkOption[0])) continue;
                    effectiveArgs.addAll(Files.readAllLines(argsFile, StandardCharsets.UTF_8));
                    continue;
                }
                if ("-recursiveStart".equals(args[i])) {
                    recursiveStart = true;
                    continue;
                }
                if (!"-gpuDetect".equals(args[i])) continue;
                gpuDetect = true;
            }
            APP_ARGS = effectiveArgs;
            for (i = 0; i < effectiveArgs.size(); ++i) {
                if ("-parentPID".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    parentPID = Long.parseLong((String)effectiveArgs.get(i + 1));
                    continue;
                }
                if ("-parentStarted".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    parentStarted = Long.parseLong((String)effectiveArgs.get(i + 1));
                    continue;
                }
                if ("-crashAssistantModJarName".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    crashAssistantModJarName = (String)effectiveArgs.get(i + 1);
                    continue;
                }
                if ("-classPath".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    classPath = (String)effectiveArgs.get(i + 1);
                    continue;
                }
                if ("-serialisedGPUs".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    serialisedGPUs = new String(Base64.getDecoder().decode((String)effectiveArgs.get(i + 1)), StandardCharsets.UTF_8);
                    continue;
                }
                if ("-minecraftStartCommand".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    MINECRAFT_LAUNCH_COMMAND = new String(Base64.getDecoder().decode((String)effectiveArgs.get(i + 1)), StandardCharsets.UTF_8);
                    continue;
                }
                if ("-minecraftJvmArgs".equals(effectiveArgs.get(i)) && i + 1 < effectiveArgs.size()) {
                    MINECRAFT_JVM_ARGS = new String(Base64.getDecoder().decode((String)effectiveArgs.get(i + 1)), StandardCharsets.UTF_8);
                    continue;
                }
                if (!"-modLoadedWithConnector".equals(effectiveArgs.get(i))) continue;
                PlatformHelp.modLoadedWithConnector = true;
            }
            List<String> missingParameters = Boot.getMissingParameters();
            if (!missingParameters.isEmpty()) {
                System.err.println("Missing required parameters: " + String.join((CharSequence)", ", missingParameters) + "\nIf you trying to run app from dev env, run CrashAssistantApp.");
                System.exit(-1);
            }
            if (gpuDetect) {
                Boot.loadVulkanAddon();
                try {
                    Class<?> GPUDetectorClass = Class.forName("dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPUDetector");
                    Method getSerialisedGPUsMethod = GPUDetectorClass.getMethod("getSerialisedGPUs", new Class[0]);
                    serialisedGPUs = (String)getSerialisedGPUsMethod.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    serialisedGPUs = ErrorUtils.getErrorMessageAndStackTrace((Throwable)e);
                }
                System.out.println(serialisedGPUs);
                System.exit(0);
            }
            if (!recursiveStart) {
                ArrayList<String> baseChildCommand = new ArrayList<String>();
                baseChildCommand.add(JavaBinaryLocator.getJavaBinary());
                baseChildCommand.addAll(JVM_ARGS);
                baseChildCommand.add("-cp");
                baseChildCommand.add(classPath);
                baseChildCommand.add("dev.kostromdan.mods.crash_assistant.app.class_loading.Boot");
                baseChildCommand.add("--args-file");
                baseChildCommand.add(argsFilePath);
                serialisedGPUs = Boot.getSerializedGPUsOnAnotherProcess(new ArrayList<String>(baseChildCommand));
                if (serialisedGPUs != null) {
                    String encodedGPUs = Base64.getEncoder().encodeToString(serialisedGPUs.getBytes(StandardCharsets.UTF_8));
                    Files.write(Paths.get(argsFilePath, new String[0]), Arrays.asList("-serialisedGPUs", encodedGPUs), StandardOpenOption.APPEND);
                }
                ArrayList<String> finalLaunchCommand = new ArrayList<String>(baseChildCommand);
                finalLaunchCommand.add("-recursiveStart");
                ProcessBuilder pb = new ProcessBuilder(finalLaunchCommand);
                pb.start();
                System.exit(0);
            }
            Class<?> crashAssistantAppClass = Class.forName("dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp");
            Method mainMethod = crashAssistantAppClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{effectiveArgs.toArray(new String[0])});
        }
        catch (Throwable e) {
            Path logsFolder = Paths.get("logs", "crash_assistant");
            Files.createDirectories(logsFolder, new FileAttribute[0]);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String errorDetails = "CrashAssistantApp process failed to start due to errors below:\nCrash Assistant won't work.\nThis won't cause any issues to the main game process, just Crash Assistant won't popup after crash.\nPlease report to https://github.com/KostromDan/Crash-Assistant/issues\n" + sw.toString();
            Path errorFile = logsFolder.resolve("app_start_error.txt");
            try {
                Files.write(errorFile, (errorDetails + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            }
            catch (IOException ioe) {
                System.err.println("Failed to write crash log: " + ioe.getMessage());
            }
        }
    }

    private static List<String> getMissingParameters() {
        ArrayList<String> missingParameters = new ArrayList<String>();
        if (crashAssistantModJarName == null) {
            missingParameters.add("-crashAssistantModJarName");
        }
        if (classPath == null) {
            missingParameters.add("-classPath");
        }
        return missingParameters;
    }

    private static void loadVulkanAddon() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSerializedGPUsOnAnotherProcess(List<String> argsList) {
        try {
            argsList.add("-gpuDetect");
            ProcessBuilder pb = new ProcessBuilder(argsList);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            boolean finished = process.waitFor(10000L, TimeUnit.MILLISECONDS);
            if (!finished) {
                process.destroyForcibly();
                throw new RuntimeException("GPUDetector process reached timeout of 10 seconds and was killed.");
            }
            int exitCode = process.exitValue();
            try (InputStream is = process.getInputStream();){
                int bytesRead;
                StringBuilder output = new StringBuilder();
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer)) != -1) {
                    output.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                }
                String result = output.toString();
                if (exitCode == 0) {
                    String string2 = result;
                    return string2;
                }
                String string = "GPUDetector process exited with non zero exit code: " + exitCode + "\nSTDOUT:\n" + result;
                return string;
            }
        }
        catch (Throwable ignored) {
            return "Error while getting gpus with GPUDetector process: " + ErrorUtils.getErrorMessageAndStackTrace((Throwable)ignored);
        }
    }
}

