/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.utils.LinksHelper;
import dev.kostromdan.mods.crash_assistant.app.utils.UploadedLog;
import dev.kostromdan.mods.crash_assistant.app.utils.UploadedLogsManager;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.ApiProvider;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.DeletionResult;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class LogDeletionDialog
extends JDialog {
    private final JPanel listPanel;
    private final JLabel emptyLabel;

    public LogDeletionDialog(Frame owner) {
        super(owner, LanguageProvider.get((String)"gui.log_deletion.title"), true);
        this.setDefaultCloseOperation(2);
        this.setSize(owner.getWidth(), owner.getHeight());
        this.setMinimumSize(new Dimension(owner.getWidth(), owner.getHeight()));
        this.setLocationRelativeTo(owner);
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.setContentPane(mainPanel);
        JEditorPane helpPane = CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.log_deletion.help"), true);
        helpPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)helpPane, "North");
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
        JScrollPane scrollPane = new JScrollPane(this.listPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        mainPanel.add((Component)scrollPane, "Center");
        this.emptyLabel = new JLabel(LanguageProvider.get((String)"gui.log_deletion.empty"), 0);
        this.emptyLabel.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.refreshLogs();
    }

    private void refreshLogs() {
        this.listPanel.removeAll();
        List<UploadedLog> logs = UploadedLogsManager.getSavedLogs();
        if (logs.isEmpty()) {
            this.listPanel.add(this.emptyLabel);
        } else {
            logs.sort((l1, l2) -> Long.compare(l2.getUploadTime(), l1.getUploadTime()));
            for (UploadedLog log : logs) {
                this.listPanel.add(this.createLogEntryPanel(log));
                this.listPanel.add(Box.createVerticalStrut(5));
            }
        }
        this.listPanel.revalidate();
        this.listPanel.repaint();
    }

    private JPanel createLogEntryPanel(UploadedLog log) {
        JPanel panel = new JPanel(new BorderLayout(10, 5));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), new EmptyBorder(5, 5, 5, 5)));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        JPanel infoPanel = new JPanel(new GridLayout(2, 1));
        JLabel nameLabel = new JLabel("<html><b>" + log.getName() + "</b></html>");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JLabel dateLabel = new JLabel(sdf.format(new Date(log.getUploadTime())));
        dateLabel.setForeground(Color.GRAY);
        infoPanel.add(nameLabel);
        infoPanel.add(dateLabel);
        panel.add((Component)infoPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 0));
        JButton openButton = new JButton(LanguageProvider.get((String)"gui.log_deletion.open"));
        openButton.addActionListener(e -> {
            try {
                CrashAssistantApp.LOGGER.info("User requested to open log in browser: {}", (Object)log.getUrl());
                LinksHelper.browse(new URI(log.getUrl()));
            }
            catch (Exception ex) {
                CrashAssistantApp.LOGGER.error("Failed to open log URL", (Throwable)ex);
            }
        });
        JButton deleteButton = new JButton(LanguageProvider.get((String)"gui.log_deletion.delete"));
        deleteButton.addActionListener(e -> this.handleDelete(log));
        buttonPanel.add(openButton);
        buttonPanel.add(deleteButton);
        panel.add((Component)buttonPanel, "East");
        return panel;
    }

    private void handleDelete(UploadedLog log) {
        CrashAssistantApp.LOGGER.info("User requested to delete log: {} ({})", (Object)log.getName(), (Object)log.getUrl());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String msg = LanguageProvider.get((String)"gui.log_deletion.delete_confirm_msg").replace("$NAME$", log.getName()).replace("$DATE$", sdf.format(new Date(log.getUploadTime())));
        int confirm = JOptionPane.showConfirmDialog(this, msg, LanguageProvider.get((String)"gui.log_deletion.delete_confirm_title"), 0, 2);
        if (confirm != 0) {
            return;
        }
        JDialog loadingDialog = new JDialog(this, LanguageProvider.get((String)"gui.log_deletion.status.deleting"), true);
        loadingDialog.setDefaultCloseOperation(0);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new EmptyBorder(20, 20, 20, 20));
        p.add((Component)new JLabel(LanguageProvider.get((String)"gui.log_deletion.status.deleting"), 0), "Center");
        loadingDialog.setContentPane(p);
        loadingDialog.setSize(200, 100);
        loadingDialog.setLocationRelativeTo(this);
        String id = log.getUrl().substring(log.getUrl().lastIndexOf(47) + 1);
        ApiProvider.getMcLogsClient().deleteLog(id, log.getDeleteToken()).thenAccept(response -> SwingUtilities.invokeLater(() -> {
            loadingDialog.dispose();
            if (response.getResult() == DeletionResult.SUCCESS) {
                CrashAssistantApp.LOGGER.info("Log deletion successful: {}", (Object)log.getUrl());
                UploadedLogsManager.removeLog(log);
                JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.log_deletion.success"));
                this.refreshLogs();
            } else if (response.getResult() == DeletionResult.NOT_FOUND) {
                CrashAssistantApp.LOGGER.warn("Log deletion failed (Not Found): {}", (Object)log.getUrl());
                UploadedLogsManager.removeLog(log);
                JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.log_deletion.not_found"), "Warning", 2);
                this.refreshLogs();
            } else {
                String errorMsg = response.getMessage();
                CrashAssistantApp.LOGGER.error("Log deletion failed: {} - {}", (Object)log.getUrl(), (Object)errorMsg);
                String userMsg = LanguageProvider.get((String)"gui.log_deletion.failed") + "\n\n" + errorMsg;
                JOptionPane.showMessageDialog(this, userMsg, "Error", 0);
            }
        }));
        loadingDialog.setVisible(true);
    }
}

