/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PiracyWarning
extends JDialog {
    public static boolean isCurrentlyDisplayed = false;

    public PiracyWarning(Frame parent) {
        super(parent, LanguageProvider.get((String)"gui.piracy_warning"), true);
        String content = LanguageProvider.get((String)"warnings.piracy").replace("$HELP_NAME$", PlatformHelp.getActualHelpName());
        JEditorPane editorPane = CrashAssistantGUI.getEditorPane(content, false);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        textPanel.add((Component)editorPane, "Center");
        JCheckBox dontShowAgainCheck = new JCheckBox(LanguageProvider.get((String)"gui.intel_corrupted_dont_show_again"));
        dontShowAgainCheck.addActionListener(e -> {
            CrashAssistantLocalConfig.set((String)"piracy.dont_show_again", (Object)dontShowAgainCheck.isSelected());
            CrashAssistantApp.LOGGER.info("Piracy Warning Don't show again checkbox switched: {}", (Object)dontShowAgainCheck.isSelected());
        });
        JButton okButton = new JButton(LanguageProvider.get((String)"gui.ok"));
        okButton.addActionListener(e -> this.dispose());
        JPanel bottomPanel = new JPanel(new FlowLayout(1, 10, 5));
        bottomPanel.add(dontShowAgainCheck);
        bottomPanel.add(okButton);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 5));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)textPanel, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        this.setContentPane(mainPanel);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        int delay = CrashAssistantConfig.getInteger((String)"piracy.delay");
        if (delay > 0) {
            okButton.setEnabled(false);
            int[] secondsLeft = new int[]{delay};
            okButton.setText(LanguageProvider.get((String)"gui.ok") + " (" + secondsLeft[0] + ")");
            Timer timer = new Timer(1000, null);
            timer.addActionListener(e -> {
                secondsLeft[0] = secondsLeft[0] - 1;
                if (secondsLeft[0] <= 0) {
                    okButton.setText(LanguageProvider.get((String)"gui.ok"));
                    okButton.setEnabled(true);
                    timer.stop();
                } else {
                    okButton.setText(LanguageProvider.get((String)"gui.ok") + " (" + secondsLeft[0] + ")");
                }
            });
            timer.start();
        } else {
            okButton.setText(LanguageProvider.get((String)"gui.ok"));
            okButton.setEnabled(true);
        }
    }

    public static void showWarning(Frame parent) {
        isCurrentlyDisplayed = true;
        SwingUtilities.invokeLater(() -> {
            CrashAssistantApp.LOGGER.warn("Showing PiracyWarning.");
            PiracyWarning dialog = new PiracyWarning(parent);
            CrashAssistantGUI.setUpIcon(dialog);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    CrashAssistantApp.LOGGER.warn("Shown PiracyWarning.");
                    isCurrentlyDisplayed = false;
                }
            });
            dialog.setVisible(true);
        });
        PiracyWarning.awaitShown();
    }

    public static void awaitShown() {
        while (isCurrentlyDisplayed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

