/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis;

import com.google.gson.JsonParseException;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.FilesRemover;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.AnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.ConfigChecker;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.ConfigCheckerRegistry;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.io.ParsingException;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CorruptedConfigFinderGUI
extends AnalysisGUIBase {
    private static final String ERROR_PLACEHOLDER = "$ERROR$";
    private static final Path WORKSPACE_ROOT = Paths.get("", new String[0]).toAbsolutePath().normalize();
    private static final Set<String> TOML_EXTENSIONS = new LinkedHashSet<String>(Arrays.asList("toml"));
    private static final Set<String> JSON_EXTENSIONS = new LinkedHashSet<String>(Arrays.asList("json", "json5"));
    private static final Set<String> SUPPORTED_EXTENSIONS = ConfigCheckerRegistry.getSupportedExtensions();
    private final Map<String, Path> configsForRemoval = new LinkedHashMap<String, Path>();

    public CorruptedConfigFinderGUI(JFrame parent) {
        super(parent, LanguageProvider.get((String)"gui.menu.analysis.corrupted_config_finder"), LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.header"));
        this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.status"));
        this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.current_file") + " " + LanguageProvider.get((String)"gui.analysis.none"));
    }

    public static void showDialog(JFrame parent) {
        new CorruptedConfigFinderGUI(parent).start();
    }

    @Override
    protected void performAnalysis() {
        List<Path> configFiles = CorruptedConfigFinderGUI.discoverConfigFiles();
        int totalFiles = configFiles.size();
        AtomicInteger completed = new AtomicInteger(0);
        AtomicBoolean headerShown = new AtomicBoolean(false);
        AtomicBoolean anyCorruptionFound = new AtomicBoolean(false);
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(Math.max(1, totalFiles)));
        for (Path configFile : configFiles) {
            executor.submit(() -> {
                if (isCancelled) {
                    return;
                }
                String displayName = CorruptedConfigFinderGUI.toDisplayPath(configFile);
                CrashAssistantApp.LOGGER.info("[CorruptedConfigFinder] Checking {}", (Object)displayName);
                SwingUtilities.invokeLater(() -> this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.current_file") + " " + displayName));
                CorruptionRecord record = this.inspectConfigFile(configFile, displayName);
                if (record != null) {
                    this.registerConfigForRemoval(record.displayName, record.path);
                    anyCorruptionFound.set(true);
                    this.logCorruption(record);
                    SwingUtilities.invokeLater(() -> {
                        boolean first = headerShown.compareAndSet(false, true);
                        this.appendRecord(record, first);
                    });
                }
                int done = completed.incrementAndGet();
                SwingUtilities.invokeLater(() -> {
                    if (!isCancelled) {
                        this.progressBar.setValue(done);
                    }
                });
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isCancelled && !anyCorruptionFound.get()) {
            SwingUtilities.invokeLater(() -> this.appendStyledText(LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.no_issues"), NORMAL_COLOR));
        }
    }

    @Override
    protected void addOkButton() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton detectedConfigsButton = new JButton(LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.remover_button"));
        detectedConfigsButton.setEnabled(this.hasConfigsForRemoval());
        detectedConfigsButton.addActionListener(e -> {
            Map<String, Path> map = this.buildConfigsRemovalMap();
            if (map.isEmpty()) {
                JOptionPane.showMessageDialog(this.dialog, LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.no_detected_configs"), LanguageProvider.get((String)"gui.files_remover.title"), 1);
                return;
            }
            FilesRemover.showDialog((Window)this.dialog, map, FilesRemover.Mode.CONFIG);
        });
        buttonPanel.add(detectedConfigsButton);
        String whyButtonKey = this.getWhyButtonTextKey();
        if (whyButtonKey != null) {
            JButton whyButton = new JButton(LanguageProvider.get((String)whyButtonKey));
            whyButton.addActionListener(e -> {
                String titleKey = this.getWhyDialogTitleKey();
                String bodyKey = this.getWhyDialogBodyKey();
                String title = titleKey != null ? LanguageProvider.get((String)titleKey) : "";
                String body = bodyKey != null ? LanguageProvider.get((String)bodyKey) : "";
                int width = this.getWhyDialogWidth();
                JEditorPane infoPane = CrashAssistantGUI.getEditorPane(body, true, width);
                JOptionPane.showMessageDialog(this.dialog, infoPane, title, 1);
            });
            buttonPanel.add(whyButton);
        }
        JButton okButton = new JButton(LanguageProvider.get((String)"gui.ok"));
        okButton.addActionListener(e -> this.dialog.dispose());
        buttonPanel.add(okButton);
        this.dialog.add((Component)buttonPanel, "South");
        this.dialog.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasConfigsForRemoval() {
        Map<String, Path> map = this.configsForRemoval;
        synchronized (map) {
            return !this.configsForRemoval.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Path> buildConfigsRemovalMap() {
        LinkedHashMap<String, Path> copy = new LinkedHashMap<String, Path>();
        Map<String, Path> map = this.configsForRemoval;
        synchronized (map) {
            this.configsForRemoval.forEach((display, path) -> copy.put((String)display, (Path)path));
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConfigForRemoval(String displayName, Path path) {
        Path absolute = path.toAbsolutePath().normalize();
        Map<String, Path> map = this.configsForRemoval;
        synchronized (map) {
            this.configsForRemoval.putIfAbsent(displayName, absolute);
        }
    }

    private void appendRecord(CorruptionRecord record, boolean isFirst) {
        if (isFirst) {
            this.appendStyledText(LanguageProvider.get((String)"gui.analysis.corrupted_config_finder.found_header") + "\n", NORMAL_COLOR);
        }
        this.appendStyledText(record.displayName + "\n", MOD_COLOR);
        this.appendStyledText("  - " + record.formattedReason() + "\n\n", ERROR_COLOR);
    }

    private void logCorruption(CorruptionRecord record) {
        CrashAssistantApp.LOGGER.warn("[CorruptedConfigFinder] {} -> {}", (Object)record.displayName, (Object)record.formattedReason());
    }

    private CorruptionRecord inspectConfigFile(Path path, String displayName) {
        String detail;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        String extension = CorruptedConfigFinderGUI.getExtension(path);
        if (!SUPPORTED_EXTENSIONS.contains(extension)) {
            return null;
        }
        try {
            if (Files.size(path) == 0L) {
                return new CorruptionRecord(path, displayName, CorruptionReason.EMPTY, null);
            }
        }
        catch (IOException ioe) {
            return new CorruptionRecord(path, displayName, CorruptionReason.IO_ERROR, CorruptedConfigFinderGUI.safeMessage(ioe));
        }
        List<ConfigChecker> checkers = ConfigCheckerRegistry.getCheckers(extension);
        if (checkers.isEmpty()) {
            CrashAssistantApp.LOGGER.warn("[CorruptedConfigFinder] No checkers registered for extension '{}'", (Object)extension);
            return null;
        }
        ArrayList<String> parsingErrors = new ArrayList<String>();
        ArrayList<String> ioErrors = new ArrayList<String>();
        for (ConfigChecker checker : checkers) {
            try {
                checker.check(path);
                CrashAssistantApp.LOGGER.info("[CorruptedConfigFinder] {} validated by {}", (Object)displayName, (Object)checker.getName());
                return null;
            }
            catch (IOException ioe) {
                ioErrors.add(CorruptedConfigFinderGUI.formatCheckerFailure(checker, ioe));
                CrashAssistantApp.LOGGER.warn("[CorruptedConfigFinder] {} failed {} due to IO error: {}", (Object)displayName, (Object)checker.getName(), (Object)CorruptedConfigFinderGUI.safeMessage(ioe));
            }
            catch (JsonParseException | ParsingException pe) {
                parsingErrors.add(CorruptedConfigFinderGUI.formatCheckerFailure(checker, (Exception)pe));
                CrashAssistantApp.LOGGER.warn("[CorruptedConfigFinder] {} failed {} due to parsing error: {}", (Object)displayName, (Object)checker.getName(), (Object)CorruptedConfigFinderGUI.safeMessage(pe));
            }
            catch (Exception ex) {
                parsingErrors.add(CorruptedConfigFinderGUI.formatCheckerFailure(checker, ex));
                CrashAssistantApp.LOGGER.warn("[CorruptedConfigFinder] {} failed {}: {}", (Object)displayName, (Object)checker.getName(), (Object)CorruptedConfigFinderGUI.safeMessage(ex));
            }
        }
        if (!ioErrors.isEmpty()) {
            detail = String.join((CharSequence)"\n  - ", ioErrors);
            return new CorruptionRecord(path, displayName, CorruptionReason.IO_ERROR, detail);
        }
        detail = parsingErrors.isEmpty() ? null : String.join((CharSequence)"\n  - ", parsingErrors);
        CorruptionReason reason = TOML_EXTENSIONS.contains(extension) ? CorruptionReason.INVALID_TOML : CorruptionReason.INVALID_JSON;
        return new CorruptionRecord(path, displayName, reason, detail);
    }

    private static String safeMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String message = throwable.getMessage();
        return message == null ? throwable.getClass().getSimpleName() : message;
    }

    private static String formatCheckerFailure(ConfigChecker checker, Exception exception) {
        return checker.getName() + ": " + CorruptedConfigFinderGUI.safeMessage(exception);
    }

    private static String getExtension(Path path) {
        String name = path.getFileName().toString();
        int dot = name.lastIndexOf(46);
        if (dot == -1 || dot == name.length() - 1) {
            return "";
        }
        return name.substring(dot + 1).toLowerCase(Locale.ROOT);
    }

    private static String toDisplayPath(Path path) {
        Path absolute = path.toAbsolutePath().normalize();
        try {
            Path relative = WORKSPACE_ROOT.relativize(absolute);
            return relative.toString().replace('\\', '/');
        }
        catch (IllegalArgumentException ignored) {
            return absolute.toString().replace('\\', '/');
        }
    }

    private static List<Path> discoverConfigFiles() {
        LinkedHashSet<Path> found = new LinkedHashSet<Path>();
        CorruptedConfigFinderGUI.collectFiles(Paths.get("config", new String[0]), found);
        CorruptedConfigFinderGUI.collectFiles(Paths.get("defaultconfigs", new String[0]), found);
        CorruptedConfigFinderGUI.collectServerConfigFiles(Paths.get("saves", new String[0]), found);
        return new ArrayList<Path>(found);
    }

    private static void collectFiles(Path root, Set<Path> out) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            stream.filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(path -> SUPPORTED_EXTENSIONS.contains(CorruptedConfigFinderGUI.getExtension(path))).forEach(p -> out.add((Path)p));
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to enumerate configs under {}", (Object)root, (Object)e);
        }
    }

    private static void collectServerConfigFiles(Path savesRoot, Set<Path> out) {
        if (!Files.isDirectory(savesRoot, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> worlds = Files.list(savesRoot);){
            worlds.filter(p -> Files.isDirectory(p, new LinkOption[0])).map(world -> world.resolve("serverconfig")).filter(p -> Files.isDirectory(p, new LinkOption[0])).forEach(serverConfigDir -> CorruptedConfigFinderGUI.collectFiles(serverConfigDir, out));
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to enumerate saves for CorruptedConfigFinder", (Throwable)e);
        }
    }

    private static final class CorruptionRecord {
        final Path path;
        final String displayName;
        final CorruptionReason reason;
        final String detail;

        CorruptionRecord(Path path, String displayName, CorruptionReason reason, String detail) {
            this.path = path;
            this.displayName = displayName;
            this.reason = reason;
            this.detail = detail;
        }

        String formattedReason() {
            return this.reason.format(this.detail);
        }
    }

    private static enum CorruptionReason {
        EMPTY("gui.analysis.corrupted_config_finder.reason.empty", false),
        INVALID_TOML("gui.analysis.corrupted_config_finder.reason.invalid_toml", true),
        INVALID_JSON("gui.analysis.corrupted_config_finder.reason.invalid_json", true),
        IO_ERROR("gui.analysis.corrupted_config_finder.reason.io_error", true);

        private final String langKey;
        private final boolean usesError;

        private CorruptionReason(String langKey, boolean usesError) {
            this.langKey = langKey;
            this.usesError = usesError;
        }

        public String format(String detail) {
            String template = LanguageProvider.get((String)this.langKey);
            if (this.usesError) {
                String replacement = detail == null ? "" : detail;
                return template.replace(CorruptedConfigFinderGUI.ERROR_PLACEHOLDER, replacement);
            }
            return template;
        }
    }
}

