/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.modlist;

import dev.kostromdan.mods.crash_assistant.app.gui.modlist.ModListDiffDialog;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api.CurseForge;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api.Modrinth;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.UpdatedPair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class DiffEntry {
    final ModListDiffDialog.SectionType type;
    final List<ModInstance> currentMods;
    final List<ModInstance> savedMods;
    final boolean messyPair;
    final String tooltip;
    boolean selected = true;
    boolean resolved = false;
    boolean removedByAction = false;
    ModListDiffDialog.SectionAction resolvedBy = null;
    ModListDiffDialog.ActionState revertState = ModListDiffDialog.ActionState.IDLE;
    ModListDiffDialog.ActionState restoreState = ModListDiffDialog.ActionState.IDLE;
    final boolean modloaderEntry;

    DiffEntry(ModListDiffDialog.SectionType type, Mod currentMod, Mod savedMod) {
        this.type = type;
        this.currentMods = currentMod == null ? Collections.emptyList() : Collections.singletonList(ModInstance.fromMod(currentMod));
        this.savedMods = savedMod == null ? Collections.emptyList() : Collections.singletonList(ModInstance.fromMod(savedMod));
        this.messyPair = currentMod != null && currentMod.isModMessedUpWithVersion();
        this.tooltip = this.buildTooltip(this.currentMods, this.savedMods);
        this.modloaderEntry = this.detectModloader(this.currentMods, this.savedMods);
        this.selected = !this.modloaderEntry;
    }

    DiffEntry(UpdatedPair pair) {
        this.type = ModListDiffDialog.SectionType.UPDATED;
        this.currentMods = this.toInstances(pair.getNewMods());
        this.savedMods = this.toInstances(pair.getOldMods());
        this.messyPair = this.computeMessy(pair);
        this.tooltip = this.buildTooltip(this.currentMods, this.savedMods);
        this.modloaderEntry = this.detectModloader(this.currentMods, this.savedMods);
        this.selected = !this.modloaderEntry;
    }

    private List<ModInstance> toInstances(Iterable<Mod> mods) {
        ArrayList<ModInstance> list = new ArrayList<ModInstance>();
        if (mods == null) {
            return list;
        }
        for (Mod mod : mods) {
            if (mod == null) continue;
            list.add(ModInstance.fromMod(mod));
        }
        return list;
    }

    private boolean computeMessy(UpdatedPair pair) {
        if (pair != null && pair.isAnyModMessedUpWithVersion()) {
            return true;
        }
        return this.currentMods.stream().anyMatch(ModInstance::isMessy) || this.savedMods.stream().anyMatch(ModInstance::isMessy);
    }

    private String buildTooltip(List<ModInstance> current, List<ModInstance> saved) {
        ModInstance newMod;
        ModInstance oldMod = saved.isEmpty() ? null : saved.get(0);
        ModInstance modInstance = newMod = current.isEmpty() ? null : current.get(0);
        if (oldMod != null && newMod != null) {
            return oldMod.fileName() + " \u2192 " + newMod.fileName();
        }
        return null;
    }

    private boolean detectModloader(List<ModInstance> current, List<ModInstance> saved) {
        for (ModInstance mi : current) {
            if (!this.isModloader(mi.fileName())) continue;
            return true;
        }
        for (ModInstance mi : saved) {
            if (!this.isModloader(mi.fileName())) continue;
            return true;
        }
        return false;
    }

    private boolean isModloader(String name) {
        String dn = name == null ? "" : name.toLowerCase(Locale.ROOT);
        return dn.endsWith("(modloader)");
    }

    boolean isMessyForDisplay() {
        return this.messyPair;
    }

    List<String> currentDisplayLines() {
        boolean messy = this.isMessyForDisplay();
        ArrayList<String> lines = new ArrayList<String>();
        for (ModInstance mi : this.currentMods) {
            Object baseName = mi.fileName();
            if (!messy && mi.mod != null && mi.mod.isModMessedUpWithVersion() && this.hasText(mi.mod.getVersion())) {
                baseName = (String)baseName + " (" + mi.mod.getVersion() + ")";
            }
            lines.add((String)baseName);
        }
        if (lines.isEmpty()) {
            lines.add("-");
        }
        return lines;
    }

    List<String> savedDisplayLines() {
        boolean messy = this.isMessyForDisplay() || this.type == ModListDiffDialog.SectionType.REMOVED;
        ArrayList<String> lines = new ArrayList<String>();
        for (ModInstance mi : this.savedMods) {
            String v;
            if (messy) {
                lines.add(mi.fileName());
                continue;
            }
            String string = v = mi.mod != null ? mi.mod.getVersion() : null;
            if (this.hasText(v)) {
                lines.add(v);
                continue;
            }
            lines.add(mi.fileName());
        }
        if (lines.isEmpty()) {
            lines.add("-");
        }
        return lines;
    }

    int maxDisplayLines() {
        if (this.type == ModListDiffDialog.SectionType.UPDATED) {
            return Math.max(this.currentDisplayLines().size(), this.savedDisplayLines().size());
        }
        if (this.type == ModListDiffDialog.SectionType.REMOVED) {
            return Math.max(1, this.savedDisplayLines().size());
        }
        return Math.max(1, this.currentDisplayLines().size());
    }

    List<String> primaryDisplayLines() {
        if (this.type == ModListDiffDialog.SectionType.REMOVED && !this.savedMods.isEmpty()) {
            return this.savedDisplayLines();
        }
        if (this.type == ModListDiffDialog.SectionType.UPDATED && this.currentMods.isEmpty() && !this.savedMods.isEmpty()) {
            return this.savedDisplayLines();
        }
        return this.currentDisplayLines();
    }

    String primaryDisplayText() {
        return this.toMultiline(this.primaryDisplayLines());
    }

    String savedDisplayText() {
        return this.toMultiline(this.savedDisplayLines());
    }

    private String toMultiline(List<String> lines) {
        if (lines.isEmpty()) {
            return "-";
        }
        if (lines.size() == 1) {
            return this.escape(lines.get(0));
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (int i = 0; i < lines.size(); ++i) {
            sb.append(this.escape(lines.get(i)));
            if (i >= lines.size() - 1) continue;
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private String escape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private boolean hasText(String s) {
        return s != null && !s.isEmpty();
    }

    boolean hasAnyCurseMatch() {
        for (ModInstance mi : this.currentMods) {
            if (mi.curseMatch == null) continue;
            return true;
        }
        for (ModInstance mi : this.savedMods) {
            if (mi.curseMatch == null) continue;
            return true;
        }
        return false;
    }

    boolean hasAnyModrinthMatch() {
        for (ModInstance mi : this.currentMods) {
            if (mi.modrinthMatch == null) continue;
            return true;
        }
        for (ModInstance mi : this.savedMods) {
            if (mi.modrinthMatch == null) continue;
            return true;
        }
        return false;
    }

    Set<Long> getCurseHashes(boolean includeSaved) {
        HashSet<Long> set = new HashSet<Long>();
        for (ModInstance mi : this.currentMods) {
            if (mi.curseHash == null) continue;
            set.add(mi.curseHash);
        }
        if (includeSaved) {
            for (ModInstance mi : this.savedMods) {
                if (mi.curseHash == null) continue;
                set.add(mi.curseHash);
            }
        }
        return set;
    }

    Set<String> getModrinthHashes(boolean includeSaved) {
        HashSet<String> set = new HashSet<String>();
        for (ModInstance mi : this.currentMods) {
            if (mi.modrinthHash == null) continue;
            set.add(mi.modrinthHash);
        }
        if (includeSaved) {
            for (ModInstance mi : this.savedMods) {
                if (mi.modrinthHash == null) continue;
                set.add(mi.modrinthHash);
            }
        }
        return set;
    }

    ModInstance anyCurseMatchInstance() {
        for (ModInstance mi : this.currentMods) {
            if (mi.curseMatch == null) continue;
            return mi;
        }
        for (ModInstance mi : this.savedMods) {
            if (mi.curseMatch == null) continue;
            return mi;
        }
        return null;
    }

    ModInstance anyModrinthMatchInstance() {
        for (ModInstance mi : this.currentMods) {
            if (mi.modrinthMatch == null) continue;
            return mi;
        }
        for (ModInstance mi : this.savedMods) {
            if (mi.modrinthMatch == null) continue;
            return mi;
        }
        return null;
    }

    List<Path> currentPaths() {
        ArrayList<Path> list = new ArrayList<Path>();
        for (ModInstance mi : this.currentMods) {
            if (mi.path == null) continue;
            list.add(mi.path);
        }
        return list;
    }

    List<Path> savedPaths() {
        ArrayList<Path> list = new ArrayList<Path>();
        for (ModInstance mi : this.savedMods) {
            if (mi.path == null) continue;
            list.add(mi.path);
        }
        return list;
    }

    boolean hasAnyCurrentPath() {
        return !this.currentPaths().isEmpty();
    }

    boolean areAllCurrentDisabled() {
        List<Path> paths = this.currentPaths();
        if (paths.isEmpty()) {
            return false;
        }
        for (Path p : paths) {
            if (p == null || p.getFileName().toString().endsWith(".disabled")) continue;
            return false;
        }
        return true;
    }

    static class ModInstance {
        final Mod mod;
        Path path;
        final Long curseHash;
        final String modrinthHash;
        CurseForge.FingerprintMatch curseMatch;
        Modrinth.VersionFileInfo modrinthMatch;

        static ModInstance fromMod(Mod mod) {
            return new ModInstance(mod, mod != null ? ModListUtils.MODS_FOLDER.resolve(mod.getJarName()) : null, mod != null ? mod.getCurseForgeHash() : null, ModInstance.normalizeHash(mod != null ? mod.getModrinthHash() : null));
        }

        ModInstance(Mod mod, Path path, Long curseHash, String modrinthHash) {
            this.mod = mod;
            this.path = path;
            this.curseHash = curseHash;
            this.modrinthHash = modrinthHash;
        }

        String fileName() {
            if (this.path != null && this.path.getFileName() != null) {
                return this.path.getFileName().toString();
            }
            if (this.mod != null && this.mod.getJarName() != null) {
                return this.mod.getJarName();
            }
            return "unknown";
        }

        boolean isMessy() {
            return this.mod != null && this.mod.isModMessedUpWithVersion();
        }

        private static String normalizeHash(String hash) {
            return hash == null ? null : hash.toLowerCase(Locale.ROOT);
        }
    }
}

