/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogReader;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import java.io.File;
import java.nio.file.Path;

public class Log {
    private final String name;
    private final Path path;
    private final LogType type;
    private final LogReader reader;
    private String linkToUploadedFirstLines = null;
    private String linkToUploadedLastLines = null;
    private boolean isAnalysed = false;

    public Log(LogType type, String name, Path path) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.reader = new LogReader(this);
    }

    public Log(LogType type, Path path) {
        this(type, path.getFileName().toString(), path);
    }

    public String getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public File getFile() {
        return this.path.toFile();
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }

    public LogType getType() {
        return this.type;
    }

    public LogReader getReader() {
        return this.reader;
    }

    public boolean isLogUploaded() {
        return this.linkToUploadedFirstLines != null;
    }

    public String getLinkToUploadedFirstLines() {
        return this.linkToUploadedFirstLines;
    }

    public void setLinkToUploadedFirstLines(String linkToUploadedFirstLines) {
        this.linkToUploadedFirstLines = linkToUploadedFirstLines;
    }

    public String getLinkToUploadedLastLines() {
        return this.linkToUploadedLastLines;
    }

    public void setLinkToUploadedLastLines(String linkToUploadedLastLines) {
        this.linkToUploadedLastLines = linkToUploadedLastLines;
    }

    public boolean isAnalysed() {
        return this.isAnalysed;
    }

    public void setAnalysed(boolean analysed) {
        this.isAnalysed = analysed;
    }

    public String getParentName() {
        String[] splitLog = this.getName().split(":");
        return splitLog.length == 2 ? splitLog[0] + ": " : "";
    }
}

