/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class LogComparator
implements Comparator<Log> {
    private static final List<LogType> DEFAULT_LOG_TYPE_ORDER = Arrays.asList(LogType.LOG, LogType.DEBUG_LOG, LogType.HS_ERR, LogType.STDERR_STREAM, LogType.CRASH_REPORT, LogType.DISCONNECT_CLIENT, LogType.WIN_EVENT, LogType.LAUNCHER_LOG, LogType.MIXER_LOGGER, LogType.KUBE_JS, LogType.CRAFT_TWEAKER, LogType.REI, LogType.CRASH_ASSISTANT, LogType.MOD_LIST);
    private static final List<LogType> FINAL_LOG_TYPE_ORDER = new ArrayList<LogType>();

    @Override
    public int compare(Log log1, Log log2) {
        int typeComparison = Integer.compare(FINAL_LOG_TYPE_ORDER.indexOf((Object)log1.getType()), FINAL_LOG_TYPE_ORDER.indexOf((Object)log2.getType()));
        if (typeComparison != 0) {
            return typeComparison;
        }
        return log1.getName().compareTo(log2.getName());
    }

    static {
        ArrayList logTypePriorityOverridesFromConfig = CrashAssistantConfig.getPriorityOverridesForLogsOrder();
        HashSet<LogType> addedLogTypes = new HashSet<LogType>();
        for (String logTypeString : logTypePriorityOverridesFromConfig) {
            try {
                LogType logType = Enum.valueOf(LogType.class, logTypeString);
                if (addedLogTypes.contains((Object)logType)) {
                    CrashAssistantApp.LOGGER.warn("Duplicated key in \"general.logs_priority_overrides\": \"{}\", skipping...", (Object)logTypeString);
                    continue;
                }
                FINAL_LOG_TYPE_ORDER.add(logType);
                addedLogTypes.add(logType);
            }
            catch (IllegalArgumentException e) {
                CrashAssistantApp.LOGGER.error("Cannot find LogType: \"{}\", skipping... Seems like invalid configuration in \"general.logs_priority_overrides\"", (Object)logTypeString);
            }
        }
        for (LogType logType : DEFAULT_LOG_TYPE_ORDER) {
            if (addedLogTypes.contains((Object)logType)) continue;
            FINAL_LOG_TYPE_ORDER.add(logType);
        }
    }
}

