/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.advanced;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.utils.ModuleFinder;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ModuleResolution
extends KnownCrashReason {
    public ModuleResolution() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.STDERR_STREAM);
            }
        }, LanguageProvider.get((String)"warnings.module_resolution"), new String[0]);
    }

    @Override
    public boolean matches(Log log) {
        if (CrashAssistantApp.gameLaunchedSuccessfully) {
            return false;
        }
        List<String> lastLines = log.getReader().getLastNLines(1000);
        for (int i = lastLines.size() - 1; i >= 0; --i) {
            String line = lastLines.get(i);
            if (!line.contains("java.lang.module.ResolutionException") || !line.contains(" exports package ") && !line.contains(" export package ")) continue;
            String errorLine = line.split("java.lang.module.ResolutionException: ")[1];
            Object additionalInfo = "";
            String packageName = line.contains(" exports package ") ? line.split(" exports package ")[1].split(" ")[0] : line.split(" export package ")[1].split(" ")[0];
            List<String> jarsContainingModule = ModuleFinder.findJarsInFolderAsync(Collections.singletonList(packageName), ModListUtils.getCurrentModList((boolean)true));
            if (PlatformHelp.platform == PlatformHelp.FORGE && (line.contains("and mixinextras.neoforge export package") || line.contains("Modules mixinextras.neoforge and") || line.contains("Module mixinextras.neoforge contains package"))) {
                additionalInfo = "<strong style=\"color:green\">" + LanguageProvider.get((String)"warnings.module_resolution_mixin_extras_neo", (HashMap)new HashMap<String, String>(){
                    {
                        this.put("$LINK.MIXIN_EXTRAS_NEO$", "Mixin Extras NeoForge on Forge Fix");
                    }
                }) + "</strong>\n\n";
            }
            this.message = this.message.replace("$LINE_FROM_LOG$", errorLine);
            this.message = this.message.replace("$JARS$", "<strong style='color: red;'>" + String.join((CharSequence)"\n", jarsContainingModule) + "</strong>");
            this.message = this.message.replace("$PACKAGE$", "<strong>" + packageName + "</strong>");
            this.message = this.message.replace("$FIRST_PRIORITY_WARNINGS$", (CharSequence)additionalInfo);
            return true;
        }
        return false;
    }
}

