/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.EpicFightDependenciesAnalysisGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.JFrame;

public class EpicFightAddons
extends KnownCrashReason {
    public EpicFightAddons() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.CRASH_REPORT);
            }
        }, LanguageProvider.get((String)"warnings.epic_fight_addons"), "(?i)java\\.lang\\.(ClassNotFoundException|NoClassDefFoundError): yesman[./]epicfight");
        this.autoFixButtons.put(LanguageProvider.get((String)"gui.analysis.find_incompatible_epic_fight_addons"), dialog -> EpicFightDependenciesAnalysisGUI.showEpicFightAnalysisDialog((JFrame)dialog.getOwner()));
    }

    @Override
    public boolean matches(Log log) {
        if (CrashAssistantApp.gameLaunchedSuccessfully) {
            return false;
        }
        if (ModListUtils.getCurrentModList((boolean)true).stream().noneMatch(mod -> Objects.equals(mod.getModId(), "epicfight"))) {
            return false;
        }
        ModListDiff diff = ModListDiff.getDiff((boolean)true);
        if (!PlatformHelp.isLinkDefault() && diff.getAddedMods().isEmpty() && diff.getUpdatedMods().isEmpty()) {
            return false;
        }
        return super.matches(log);
    }
}

