/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.util.HashSet;
import java.util.List;

public class ResourceLocationException
extends KnownCrashReason {
    public ResourceLocationException() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.CRASH_REPORT);
            }
        }, LanguageProvider.get((String)"warnings.resource_location_exception"), new String[0]);
    }

    @Override
    public boolean matches(Log log) {
        List<String> lines = log.getReader().getAllLinesList();
        boolean prevLineIsFailureMessage = false;
        for (int i = 0; i < lines.size(); ++i) {
            Object line = lines.get(i);
            if (((String)line).contains("Caused by: net.minecraft.ResourceLocationException: Non [a-z0-9/._-] character in path of location: ") || prevLineIsFailureMessage && ((String)line).contains("net.minecraft.ResourceLocationException: Non [a-z0-9/._-] character in path of location: ")) {
                line = !prevLineIsFailureMessage ? ((String)line).split("ResourceLocationException: ")[1] : lines.get(i - 1) + "\n" + (String)line;
                this.message = this.message.replace("$LINE_FROM_LOG$", (CharSequence)line);
                return true;
            }
            prevLineIsFailureMessage = ((String)line).contains("Failure message: ") || ((String)line).contains("encountered an error while dispatching") || ((String)line).contains("Failed to create mod instance");
        }
        return false;
    }
}

