/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;

public class TrustedDomainsHelper {
    private static final HashSet<String> trustedDomains = new HashSet<String>(){
        {
            this.add("discord.gg");
            this.add("discord.com");
            this.add("discordapp.com");
            this.add("discord.media");
            this.add("discordapp.net");
            this.add("discordcdn.com");
            this.add("discord.dev");
            this.add("discord.new");
            this.add("discord.gift");
            this.add("discordstatus.com");
            this.add("dis.gd");
            this.add("discord.co");
            this.add("qq.com");
            this.add("minecraftforge.net");
            this.add("neoforged.net");
            this.add("fabricmc.net");
            this.add("quiltmc.org");
            this.add("github.com");
            this.add("gnomebot.dev");
            this.add("mclo.gs");
            this.add("download.fo");
            this.add("t.me");
            this.add("cryprojects.ru");
            this.addAll(TrustedDomainsHelper.getDomainsFromLinksProvider());
        }
    };

    private static HashSet<String> getDomainsFromLinksProvider() {
        HashSet<String> domains = new HashSet<String>();
        for (LinksProvider provider : LinksProvider.values()) {
            try {
                URI uri;
                String domain;
                String link = provider.getLink();
                if (link == null || link.equals("PRIVACY_POLICY") || (domain = TrustedDomainsHelper.getDomainName(uri = new URI(link))) == null) continue;
                domains.add(domain);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return domains;
    }

    public static String getDomainName(URI uri) {
        String domain = uri.getHost();
        return domain.startsWith("www.") ? domain.substring(4) : domain;
    }

    public static String getTopDomainName(URI uri) {
        String domain = TrustedDomainsHelper.getDomainName(uri);
        int indexOfLastDot = domain.lastIndexOf(".");
        int indexOfSecondFromLastDot = domain.lastIndexOf(".", indexOfLastDot - 1);
        return domain.substring(indexOfSecondFromLastDot + 1);
    }

    public static boolean isTrustedTopDomain(URI uri) {
        return trustedDomains.contains(TrustedDomainsHelper.getTopDomainName(uri));
    }
}

