/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import dev.kostromdan.mods.crash_assistant.app.utils.UUIDCheckStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UUIDUtils {
    public static volatile UUIDCheckStatus status = UUIDCheckStatus.UNDEFINED;
    private static volatile long checkStartTime = 0L;
    private static final AtomicBoolean isStarted = new AtomicBoolean(false);

    public static String getParam(String paramName) {
        if (Boot.MINECRAFT_LAUNCH_COMMAND == null || Boot.MINECRAFT_LAUNCH_COMMAND.isEmpty()) {
            return null;
        }
        Pattern ARG_PATTERN = Pattern.compile("--" + paramName + "[\\s=:,]+([^\\s,]+)");
        Matcher matcher = ARG_PATTERN.matcher(Boot.MINECRAFT_LAUNCH_COMMAND);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getUUID() {
        return UUIDUtils.getParam("uuid");
    }

    public static String getUsername() {
        return UUIDUtils.getParam("username");
    }

    public static void startCheck() {
        if (isStarted.getAndSet(true)) {
            return;
        }
        checkStartTime = System.currentTimeMillis();
        status = UUIDCheckStatus.PROCESSING;
        new Thread(() -> {
            String uuid = UUIDUtils.getUUID();
            if (uuid == null) {
                status = UUIDCheckStatus.FAILED;
                return;
            }
            for (int i = 0; i < 3 && System.currentTimeMillis() - checkStartTime <= 6000L; ++i) {
                UUIDCheckStatus currentResult = UUIDUtils.verifyUUID(uuid);
                if (currentResult != UUIDCheckStatus.LICENSED && currentResult != UUIDCheckStatus.PIRACY_OR_OFFLINE) continue;
                status = currentResult;
                CrashAssistantApp.LOGGER.info("UUID({}) verification result: {}", (Object)uuid, (Object)status);
                return;
            }
            status = UUIDCheckStatus.FAILED;
        }).start();
    }

    public static UUIDCheckStatus waitAndGetStatus() {
        if (!isStarted.get()) {
            UUIDUtils.startCheck();
        }
        long totalTimeout = 6000L;
        long deadline = checkStartTime + totalTimeout;
        while ((status == UUIDCheckStatus.PROCESSING || status == UUIDCheckStatus.UNDEFINED) && System.currentTimeMillis() < deadline) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (status == UUIDCheckStatus.PROCESSING || status == UUIDCheckStatus.UNDEFINED) {
            return UUIDCheckStatus.FAILED;
        }
        return status;
    }

    public static UUIDCheckStatus verifyUUID(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return UUIDCheckStatus.FAILED;
        }
        if (!uuid.matches("^[\\w-]+$")) {
            return UUIDCheckStatus.FAILED;
        }
        String cleanUuid = uuid.replace("-", "");
        if (cleanUuid.length() != 32) {
            return UUIDCheckStatus.FAILED;
        }
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + cleanUuid + "?unsigned=false");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try {
                    StringBuilder responseBuilder = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            responseBuilder.append(line);
                        }
                    }
                    JsonObject json = JsonParser.parseString((String)responseBuilder.toString()).getAsJsonObject();
                    if (json.has("name")) {
                        String serverName = json.get("name").getAsString();
                        String actualName = UUIDUtils.getUsername();
                        if (actualName != null && !actualName.equalsIgnoreCase(serverName)) {
                            CrashAssistantApp.LOGGER.warn("UUID mismatch! mojang: {}, local: {}; assuming offline mode.", (Object)serverName, (Object)actualName);
                            return UUIDCheckStatus.PIRACY_OR_OFFLINE;
                        }
                    }
                }
                catch (Exception e) {
                    CrashAssistantApp.LOGGER.error("JSON parsing failed, defaulting to LICENSED", (Throwable)e);
                }
                return UUIDCheckStatus.LICENSED;
            }
            if (responseCode == 204 || responseCode == 404) {
                return UUIDCheckStatus.PIRACY_OR_OFFLINE;
            }
            return UUIDCheckStatus.FAILED;
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.error("Failed to verify UUID: ", (Throwable)e);
            return UUIDCheckStatus.FAILED;
        }
    }
}

