/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.utils.UploadedLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UploadedLogsManager {
    private static final Path STORAGE_PATH = Paths.get("local", "crash_assistant", "uploaded_logs.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLog(String name, String url, String deleteToken) {
        lock.writeLock().lock();
        try {
            List<UploadedLog> logs = UploadedLogsManager.loadLogsInternal();
            logs.add(new UploadedLog(name, System.currentTimeMillis(), url, deleteToken));
            UploadedLogsManager.writeLogs(logs);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to save uploaded log info", (Throwable)e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void removeLog(UploadedLog log) {
        lock.writeLock().lock();
        try {
            List<UploadedLog> logs = UploadedLogsManager.loadLogsInternal();
            logs.removeIf(l -> l.getUrl().equals(log.getUrl()));
            UploadedLogsManager.writeLogs(logs);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to remove uploaded log info", (Throwable)e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static List<UploadedLog> getSavedLogs() {
        lock.readLock().lock();
        try {
            ArrayList<UploadedLog> arrayList = new ArrayList<UploadedLog>(UploadedLogsManager.loadLogsInternal());
            return arrayList;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to load uploaded logs", (Throwable)e);
            List<UploadedLog> list = Collections.emptyList();
            return list;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static List<UploadedLog> loadLogsInternal() {
        List list;
        block9: {
            if (!Files.exists(STORAGE_PATH, new LinkOption[0])) {
                return new ArrayList<UploadedLog>();
            }
            BufferedReader reader = Files.newBufferedReader(STORAGE_PATH);
            try {
                List logs = (List)GSON.fromJson((Reader)reader, new TypeToken<List<UploadedLog>>(){}.getType());
                List list2 = list = logs != null ? logs : new ArrayList();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    CrashAssistantApp.LOGGER.error("Failed to read uploaded logs file. It might be corrupted.", (Throwable)e);
                    UploadedLogsManager.backupCorruptedFile();
                    return new ArrayList<UploadedLog>();
                }
            }
            ((Reader)reader).close();
        }
        return list;
    }

    private static void backupCorruptedFile() {
        try {
            Path backupPath = UploadedLogsManager.getNextBackupPath();
            Files.move(STORAGE_PATH, backupPath, new CopyOption[0]);
            CrashAssistantApp.LOGGER.warn("Corrupted uploaded logs file moved to: {}", (Object)backupPath.toAbsolutePath());
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.error("Failed to backup corrupted uploaded logs file", (Throwable)e);
        }
    }

    private static Path getNextBackupPath() {
        Path baseBackup = Paths.get(STORAGE_PATH.toString() + ".bak", new String[0]);
        if (!Files.exists(baseBackup, new LinkOption[0])) {
            return baseBackup;
        }
        int i = 1;
        Path nextBackup;
        while (Files.exists(nextBackup = Paths.get(STORAGE_PATH.toString() + ".bak." + i, new String[0]), new LinkOption[0])) {
            ++i;
        }
        return nextBackup;
    }

    private static void writeLogs(List<UploadedLog> logs) throws IOException {
        Path parent = STORAGE_PATH.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(STORAGE_PATH, new OpenOption[0]);){
            GSON.toJson(logs, (Appendable)writer);
        }
    }
}

