/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.kostromdan.mods.crash_assistant.app.utils.UploadedLogsManager;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.DeletionResult;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.LogAnalysisResponse;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.LogDeletionResponse;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.McLogsAntiVersionCensorer;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.Problem;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.UploadLogResponse;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.UploadingApi;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ErrorUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;

public class McLogsApi
implements UploadingApi {
    private static final String API_BASE_URL = "https://api.mclo.gs/1/";
    private static final int MAX_CONCURRENT_UPLOADS = 5;
    private static final String USER_AGENT = "CrashAssistant";
    private final String userAgent;
    private final Semaphore uploadSemaphore = new Semaphore(5);

    public McLogsApi() {
        this(USER_AGENT);
    }

    public McLogsApi(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public CompletableFuture<UploadLogResponse> uploadLog(String logName, String text, Consumer<Integer> onProgressChanged) {
        String finalText = text.isEmpty() ? "Log is empty." : McLogsAntiVersionCensorer.apply(text);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.uploadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return new UploadLogResponse("Upload interrupted during waiting for upload stage.");
            }
            try {
                if (onProgressChanged != null) {
                    onProgressChanged.accept(0);
                }
                URL url = new URL("https://api.mclo.gs/1/log?insights=true");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Encoding", "gzip");
                connection.setDoOutput(true);
                String content = "content=" + URLEncoder.encode(finalText, StandardCharsets.UTF_8.name());
                byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                    gzipOutputStream.write(contentBytes);
                }
                byte[] compressedBytes = byteArrayOutputStream.toByteArray();
                int totalBytes = compressedBytes.length;
                connection.setRequestProperty("Content-Length", String.valueOf(totalBytes));
                if (onProgressChanged != null) {
                    onProgressChanged.accept(0);
                }
                try (OutputStream os = connection.getOutputStream();){
                    int chunkSize;
                    int MIN_CHUNK = 4096;
                    int MAX_CHUNK = 65536;
                    int bytesPerPercent = (int)Math.ceil((double)totalBytes / 100.0);
                    for (chunkSize = Integer.highestOneBit(bytesPerPercent); chunkSize > bytesPerPercent && chunkSize > 4096; chunkSize >>= 1) {
                    }
                    chunkSize = Math.max(4096, Math.min(65536, chunkSize));
                    int bytesWritten = 0;
                    int lastPercent = 0;
                    while (bytesWritten < totalBytes) {
                        int len = Math.min(chunkSize, totalBytes - bytesWritten);
                        os.write(compressedBytes, bytesWritten, len);
                        int percent = (int)((long)(bytesWritten += len) * 100L / (long)totalBytes);
                        if (percent <= lastPercent || onProgressChanged == null) continue;
                        onProgressChanged.accept(percent);
                        lastPercent = percent;
                    }
                    os.flush();
                }
                int responseCode = connection.getResponseCode();
                if (onProgressChanged != null) {
                    onProgressChanged.accept(100);
                }
                if (responseCode == 200) {
                    StringBuilder responseBody = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            responseBody.append(line);
                        }
                    }
                    JsonObject jsonResponse = JsonParser.parseString((String)responseBody.toString()).getAsJsonObject();
                    if (jsonResponse.get("success").getAsBoolean()) {
                        LogAnalysisResponse analysisResponse;
                        String token;
                        String id = jsonResponse.get("id").getAsString();
                        String responseUrl = jsonResponse.get("url").getAsString();
                        String rawUrl = jsonResponse.get("raw").getAsString();
                        String string = token = jsonResponse.has("token") ? jsonResponse.get("token").getAsString() : null;
                        if (token != null) {
                            UploadedLogsManager.saveLog(logName, responseUrl, token);
                        }
                        if (jsonResponse.has("content") && jsonResponse.getAsJsonObject("content").has("insights")) {
                            JsonObject insights = jsonResponse.getAsJsonObject("content").getAsJsonObject("insights");
                            if (insights.has("analysis") && insights.getAsJsonObject("analysis").has("problems")) {
                                JsonArray problemsArray = insights.getAsJsonObject("analysis").getAsJsonArray("problems");
                                ArrayList<Problem> problems = new ArrayList<Problem>();
                                for (JsonElement problemElement : problemsArray) {
                                    JsonObject problemObject = problemElement.getAsJsonObject();
                                    String problemMessage = problemObject.get("message").getAsString();
                                    int lineNumber = 0;
                                    if (problemObject.has("entry") && problemObject.getAsJsonObject("entry").has("lines") && problemObject.getAsJsonObject("entry").getAsJsonArray("lines").size() > 0) {
                                        lineNumber = problemObject.getAsJsonObject("entry").getAsJsonArray("lines").get(0).getAsJsonObject().get("number").getAsInt();
                                    }
                                    ArrayList<String> solutions = new ArrayList<String>();
                                    if (problemObject.has("solutions")) {
                                        JsonArray solutionsArray = problemObject.getAsJsonArray("solutions");
                                        for (JsonElement solutionElement : solutionsArray) {
                                            solutions.add(solutionElement.getAsJsonObject().get("message").getAsString());
                                        }
                                    }
                                    problems.add(new Problem(lineNumber, problemMessage, solutions));
                                }
                                analysisResponse = new LogAnalysisResponse(problems);
                            } else {
                                analysisResponse = new LogAnalysisResponse("No problems found in the log");
                            }
                        } else {
                            analysisResponse = new LogAnalysisResponse("No problems found in the log");
                        }
                        UploadLogResponse uploadLogResponse = new UploadLogResponse(responseUrl, rawUrl, id, analysisResponse);
                        return uploadLogResponse;
                    }
                    String error = jsonResponse.get("error").getAsString();
                    UploadLogResponse uploadLogResponse = new UploadLogResponse(error);
                    return uploadLogResponse;
                }
                UploadLogResponse uploadLogResponse = new UploadLogResponse("HTTP error: " + responseCode);
                return uploadLogResponse;
            }
            catch (Exception e) {
                UploadLogResponse uploadLogResponse = new UploadLogResponse("Error while uploading log to mclo.gs:\n" + ErrorUtils.getErrorMessageAndStackTrace((Throwable)e));
                return uploadLogResponse;
            }
            finally {
                this.uploadSemaphore.release();
            }
        });
    }

    @Override
    public CompletableFuture<UploadLogResponse> uploadLog(String logName, String text) {
        return this.uploadLog(logName, text, null);
    }

    @Override
    public CompletableFuture<LogDeletionResponse> deleteLog(String logId, String token) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.mclo.gs/1/log/" + logId);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("DELETE");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.setRequestProperty("Authorization", "Bearer " + token);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    return new LogDeletionResponse(DeletionResult.SUCCESS, null);
                }
                if (responseCode == 404) {
                    return new LogDeletionResponse(DeletionResult.NOT_FOUND, "Log not found (404). It might have been already deleted.");
                }
                StringBuilder errorMsg = new StringBuilder();
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader2.readLine()) != null) {
                        errorMsg.append(line);
                    }
                }
                catch (Exception reader2) {
                    // empty catch block
                }
                String message = "HTTP Error: " + responseCode;
                if (errorMsg.length() > 0) {
                    message = message + "\nServer message: " + errorMsg.toString();
                }
                return new LogDeletionResponse(DeletionResult.ERROR, message);
            }
            catch (Exception e) {
                return new LogDeletionResponse(DeletionResult.ERROR, "Exception: " + e.getMessage());
            }
        });
    }
}

