/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    public static Optional<IRecipeTransferError> getTransferRecipeError(IRecipeTransferManager recipeTransferManager, class_1703 container, IRecipeLayoutDrawable<?> recipeLayout, class_1657 player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(IRecipeTransferManager recipeTransferManager, class_1703 container, IRecipeLayoutDrawable<?> recipeLayout, class_1657 player, boolean maxTransfer) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true).map(error -> error.getType().allowsTransfer).orElse(true);
    }

    private static <C extends class_1703, R> Optional<IRecipeTransferError> transferRecipe(IRecipeTransferManager recipeTransferManager, C container, IRecipeLayoutDrawable<R> recipeLayout, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        Optional<IRecipeTransferHandler<C, R>> recipeTransferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeCategory);
        if (recipeTransferHandler.isEmpty()) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return Optional.of(RecipeTransferErrorInternal.INSTANCE);
        }
        IRecipeTransferHandler<C, R> transferHandler = recipeTransferHandler.get();
        IRecipeSlotsView recipeSlotsView = recipeLayout.getRecipeSlotsView();
        try {
            IRecipeTransferError transferError = transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeSlotsView, player, maxTransfer, doTransfer);
            return Optional.ofNullable(transferError);
        }
        catch (RuntimeException e) {
            LOGGER.error("Recipe transfer handler '{}' for container '{}' and recipe type '{}' threw an error: ", transferHandler.getClass(), transferHandler.getContainerClass(), recipeCategory.getRecipeType(), (Object)e);
            return Optional.of(RecipeTransferErrorInternal.INSTANCE);
        }
    }

    public static boolean validateSlots(class_1657 player, Collection<TransferOperation> transferOperations, Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots) {
        Set<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
        Set<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
        List<Integer> invalidRecipeIndexes = transferOperations.stream().map(op -> op.craftingSlot(player.field_7512)).map(s -> s.field_7874).filter(s -> !craftingSlotIndexes.contains(s)).toList();
        if (!invalidRecipeIndexes.isEmpty()) {
            LOGGER.error("Transfer request has invalid slots for the destination of the recipe,  the slots are not included in the list of crafting slots. {}", (Object)StringUtil.intsToString(invalidRecipeIndexes));
            return false;
        }
        List<Integer> invalidInventorySlotIndexes = transferOperations.stream().map(op -> op.inventorySlot(player.field_7512)).map(s -> s.field_7874).filter(s -> !inventorySlotIndexes.contains(s) && !craftingSlotIndexes.contains(s)).toList();
        if (!invalidInventorySlotIndexes.isEmpty()) {
            LOGGER.error("Transfer request has invalid source slots for the inventory stacks for the recipe, the slots are not included in the list of inventory slots or recipe slots. {}\n inventory slots: {}\n crafting slots: {}", (Object)StringUtil.intsToString(invalidInventorySlotIndexes), (Object)StringUtil.intsToString(inventorySlotIndexes), (Object)StringUtil.intsToString(craftingSlotIndexes));
            return false;
        }
        Set<Integer> overlappingSlots = inventorySlotIndexes.stream().filter(craftingSlotIndexes::contains).collect(Collectors.toSet());
        if (!overlappingSlots.isEmpty()) {
            LOGGER.error("Transfer request has invalid slots, inventorySlots and craftingSlots should not share any slot, but both have: {}", (Object)StringUtil.intsToString(overlappingSlots));
            return false;
        }
        List<Integer> invalidFakeSlots = Stream.concat(craftingSlots.stream(), inventorySlots.stream()).filter(class_1735::method_55059).map(slot -> slot.field_7874).toList();
        if (!invalidFakeSlots.isEmpty()) {
            LOGGER.error("Transfer request has invalid slots, they are fake slots (recipe outputs): {}", (Object)StringUtil.intsToString(invalidFakeSlots));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static RecipeTransferOperationsResult getRecipeTransferOperations(IStackHelper stackhelper, Map<class_1735, class_1799> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, List<class_1735> craftingSlots) {
        void var10_13;
        RecipeTransferOperationsResult transferOperations = new RecipeTransferOperationsResult();
        IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
        IdentityHashMap<IRecipeSlotView, Set> slotUidCache = new IdentityHashMap<IRecipeSlotView, Set>();
        List<IRecipeSlotView> nonEmptyRequiredStacks = requiredItemStacks.stream().filter(r -> !r.isEmpty()).toList();
        UidHashStrategy uidHashStrategy = new UidHashStrategy(stackhelper);
        for (Map.Entry<class_1735, class_1799> entry : availableItemStacks.entrySet()) {
            class_1799 class_17992 = entry.getValue();
            Object slotItemStackUid = stackhelper.getUidForStack(class_17992, UidContext.Recipe);
            for (IRecipeSlotView iRecipeSlotView : nonEmptyRequiredStacks) {
                Set ingredientUids = slotUidCache.computeIfAbsent(iRecipeSlotView, s -> RecipeTransferUtil.calculateUids(s, stackhelper));
                if (!ingredientUids.contains(slotItemStackUid)) continue;
                relevantSlots.computeIfAbsent(iRecipeSlotView, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)uidHashStrategy)).computeIfAbsent(class_17992, it -> new ArrayList()).add(new PhantomSlotState(entry.getKey(), class_17992));
            }
        }
        Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
        for (Map.Entry entry : relevantSlots.entrySet()) {
            ArrayList<PhantomSlotStateList> countedAndSorted = new ArrayList<PhantomSlotStateList>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ((ArrayList)entry2.getValue()).sort((o1, o2) -> {
                    int compare = Integer.compare(o1.itemStack.method_7947(), o2.itemStack.method_7947());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.field_7874, o2.slot.field_7874);
                    }
                    return compare;
                });
                countedAndSorted.add(new PhantomSlotStateList((List)entry2.getValue()));
            }
            countedAndSorted.sort((o1, o2) -> {
                int compare = Long.compare(o2.totalItemCount, o1.totalItemCount);
                if (compare == 0) {
                    return Integer.compare(o1.stateList.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0), o2.stateList.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0));
                }
                return compare;
            });
            bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
        }
        boolean bl = false;
        while (var10_13 < requiredItemStacks.size()) {
            IRecipeSlotView iRecipeSlotView = requiredItemStacks.get((int)var10_13);
            if (!iRecipeSlotView.isEmpty()) {
                class_1735 craftingSlot = craftingSlots.get((int)var10_13);
                PhantomSlotState matching = null;
                List list = (List)bestMatches.get(iRecipeSlotView);
                if (list != null) {
                    for (PhantomSlotStateList phantomSlotStateList : list) {
                        PhantomSlotState first = phantomSlotStateList.getFirstNonEmpty();
                        if (first == null) continue;
                        matching = first;
                        break;
                    }
                }
                if (matching == null) {
                    transferOperations.missingItems.add(iRecipeSlotView);
                } else {
                    class_1735 matchingSlot = matching.slot;
                    class_1799 matchingStack = matching.itemStack;
                    matchingStack.method_7934(1);
                    transferOperations.results.add(new TransferOperation(matchingSlot.field_7874, craftingSlot.field_7874));
                }
            }
            ++var10_13;
        }
        return transferOperations;
    }

    private static Set<Object> calculateUids(IRecipeSlotView recipeSlotView, IStackHelper stackhelper) {
        List<@Nullable ITypedIngredient<?>> allIngredientsList = recipeSlotView.getAllIngredientsList();
        HashSet<Object> uids = new HashSet<Object>(allIngredientsList.size());
        for (ITypedIngredient<?> typedIngredient : allIngredientsList) {
            ITypedIngredient<class_1799> typedItemStack;
            if (typedIngredient == null || (typedItemStack = typedIngredient.castToItemStackType()) == null) continue;
            Object uid = stackhelper.getUidForStack(typedItemStack, UidContext.Recipe);
            uids.add(uid);
        }
        return uids;
    }

    private static class UidHashStrategy
    implements Hash.Strategy<class_1799> {
        private final IStackHelper stackhelper;

        public UidHashStrategy(IStackHelper stackhelper) {
            this.stackhelper = stackhelper;
        }

        public int hashCode(class_1799 o) {
            return o.method_7909().hashCode();
        }

        public boolean equals(class_1799 a, class_1799 b) {
            return this.stackhelper.isEquivalent(a, b, UidContext.Recipe);
        }
    }

    private record PhantomSlotState(class_1735 slot, class_1799 itemStack) {
    }

    private record PhantomSlotStateList(List<PhantomSlotState> stateList, long totalItemCount) {
        public PhantomSlotStateList(List<PhantomSlotState> states) {
            this(states, states.stream().mapToLong(it -> it.itemStack.method_7947()).sum());
        }

        @Nullable
        public PhantomSlotState getFirstNonEmpty() {
            for (PhantomSlotState state : this.stateList) {
                if (state.itemStack.method_7960()) continue;
                return state;
            }
            return null;
        }
    }
}

