/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.fallingtrees.trees;

import dev.pandasystems.fallingtrees.api.TreeData;
import dev.pandasystems.fallingtrees.api.TreeType;
import dev.pandasystems.fallingtrees.config.CommonConfig;
import dev.pandasystems.fallingtrees.config.FallingTreesConfigKt;
import dev.pandasystems.fallingtrees.config.common.tree.TreeConfig;
import dev.pandasystems.fallingtrees.entity.TreeEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\bJ\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\bJ%\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0011\u0010 \u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Ldev/pandasystems/fallingtrees/trees/ChorusTree;", "Ldev/pandasystems/fallingtrees/api/TreeType;", "<init>", "()V", "Lnet/minecraft/class_2680;", "blockState", "", "isTreeStem", "(Lnet/minecraft/class_2680;)Z", "Lnet/minecraft/class_2338;", "blockPos", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1657;", "player", "Ldev/pandasystems/fallingtrees/api/TreeData;", "gatherTreeData", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;)Ldev/pandasystems/fallingtrees/api/TreeData;", "startPos", "Ldev/pandasystems/fallingtrees/api/TreeData$Builder;", "builder", "", "gatherBlocks", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Ldev/pandasystems/fallingtrees/api/TreeData$Builder;Lnet/minecraft/class_1657;)Ljava/util/Set;", "isPlant", "isFlower", "", "gatherValidBlocksAround", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Ljava/util/List;", "Ldev/pandasystems/fallingtrees/config/common/tree/TreeConfig;", "getConfig", "()Ldev/pandasystems/fallingtrees/config/common/tree/TreeConfig;", "config", "", "Lnet/minecraft/class_2350;", "horizontalDirections", "[Lnet/minecraft/class_2350;", "fallingtrees-common-1.21.10"})
public final class ChorusTree
implements TreeType {
    @NotNull
    private final class_2350[] horizontalDirections;

    public ChorusTree() {
        class_2350[] class_2350Array = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
        this.horizontalDirections = class_2350Array;
    }

    @NotNull
    public final TreeConfig getConfig() {
        return ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getTrees().getChorusTree();
    }

    @Override
    public boolean isTreeStem(@NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return this.isPlant(blockState);
    }

    @Override
    @Nullable
    public TreeData gatherTreeData(@NotNull class_2338 blockPos, @NotNull class_1937 level, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2338 blockPos2 = blockPos;
        if (this.getConfig().getRequireTool()) {
            TreeConfig.Filter filter = this.getConfig().getAllowedToolFilter();
            class_1799 class_17992 = player.method_6047();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getMainHandItem(...)");
            if (!filter.isValid(class_17992)) {
                return null;
            }
        }
        class_2338 class_23382 = blockPos2.method_10062();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"immutable(...)");
        blockPos2 = class_23382;
        TreeData.Builder builder = new TreeData.Builder();
        Set<class_2338> blockPosSet = this.gatherBlocks(level, blockPos2, builder, player);
        return builder.addBlocks((Collection<class_2338>)blockPosSet).setToolDamage(blockPosSet.size()).setFoodExhaustionModifier(arg_0 -> ChorusTree.gatherTreeData$lambda$0(blockPosSet, arg_0)).setMiningSpeedModifier(arg_0 -> ChorusTree.gatherTreeData$lambda$1(blockPosSet, arg_0)).build();
    }

    private final Set<class_2338> gatherBlocks(class_1937 level, class_2338 startPos, TreeData.Builder builder, class_1657 player) {
        Set blocks = new LinkedHashSet();
        Queue toVisit = new LinkedList();
        Set visited = new LinkedHashSet();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.poll();
            if (visited.contains(current)) continue;
            Intrinsics.checkNotNull((Object)current);
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            Intrinsics.checkNotNull((Object)currentState);
            if (this.isFlower(currentState)) {
                blocks.add(current);
                continue;
            }
            if (!this.isPlant(currentState)) continue;
            blocks.add(current);
            class_3445 class_34452 = class_3468.field_15427.method_14956((Object)currentState.method_26204());
            Intrinsics.checkNotNullExpressionValue((Object)class_34452, (String)"get(...)");
            TreeData.Builder.addAwardedStat$default(builder, class_34452, 0, 2, null);
            if (level instanceof class_3218) {
                List list = class_2248.method_9609((class_2680)currentState, (class_3218)((class_3218)level), (class_2338)current, null, (class_1297)((class_1297)player), (class_1799)player.method_6047());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
                builder.addDrops(list);
            }
            for (class_2338 neighbor : this.gatherValidBlocksAround(level, current)) {
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return blocks;
    }

    private final boolean isPlant(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10021);
    }

    private final boolean isFlower(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10528);
    }

    private final List<class_2338> gatherValidBlocksAround(class_1937 level, class_2338 blockPos) {
        List blocks = new ArrayList();
        for (class_2350 direction : this.horizontalDirections) {
            class_2338 neighborPos = blockPos.method_10093(direction);
            class_2680 class_26802 = level.method_8320(neighborPos.method_10074());
            Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"getBlockState(...)");
            if (this.isPlant(class_26802)) continue;
            class_2680 blockState = level.method_8320(neighborPos);
            Intrinsics.checkNotNull((Object)blockState);
            if (!this.isPlant(blockState) && !this.isFlower(blockState)) continue;
            Intrinsics.checkNotNull((Object)neighborPos);
            blocks.add(neighborPos);
        }
        class_2338 neighborPos = blockPos.method_10084();
        class_2680 blockState = level.method_8320(neighborPos);
        Intrinsics.checkNotNull((Object)blockState);
        if (this.isPlant(blockState) || this.isFlower(blockState)) {
            Intrinsics.checkNotNull((Object)neighborPos);
            blocks.add(neighborPos);
        }
        return blocks;
    }

    @Override
    public void onTreeTick(@NotNull TreeEntity entity) {
        TreeType.super.onTreeTick(entity);
    }

    private static final float gatherTreeData$lambda$0(Set $blockPosSet, float originalExhaustion) {
        return originalExhaustion * (float)$blockPosSet.size();
    }

    private static final float gatherTreeData$lambda$1(Set $blockPosSet, float originalMiningSpeed) {
        float speedMultiplication = ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getSpeedMultiplication();
        float multiplyAmount = RangesKt.coerceAtMost((float)((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getMaxSpeedMultiplication(), (float)((float)$blockPosSet.size() - 1.0f));
        return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
    }
}

