/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.fallingtrees.trees;

import dev.pandasystems.fallingtrees.api.TreeData;
import dev.pandasystems.fallingtrees.api.TreeType;
import dev.pandasystems.fallingtrees.config.CommonConfig;
import dev.pandasystems.fallingtrees.config.FallingTreesConfigKt;
import dev.pandasystems.fallingtrees.config.common.tree.TreeConfig;
import dev.pandasystems.fallingtrees.config.common.tree.VerticalTreeConfig;
import dev.pandasystems.fallingtrees.entity.TreeEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Ldev/pandasystems/fallingtrees/trees/VerticalTree;", "Ldev/pandasystems/fallingtrees/api/TreeType;", "<init>", "()V", "Lnet/minecraft/class_2680;", "blockState", "", "isTreeStem", "(Lnet/minecraft/class_2680;)Z", "Lnet/minecraft/class_2338;", "blockPos", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1657;", "player", "Ldev/pandasystems/fallingtrees/api/TreeData;", "gatherTreeData", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;)Ldev/pandasystems/fallingtrees/api/TreeData;", "", "blocks", "", "gatherBlocks", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Ljava/util/List;)V", "Ldev/pandasystems/fallingtrees/config/common/tree/VerticalTreeConfig;", "getConfig", "()Ldev/pandasystems/fallingtrees/config/common/tree/VerticalTreeConfig;", "config", "fallingtrees-common-1.21.10"})
public final class VerticalTree
implements TreeType {
    @NotNull
    public final VerticalTreeConfig getConfig() {
        return ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getTrees().getVerticalTree();
    }

    @Override
    public boolean isTreeStem(@NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return this.getConfig().getFilter().isValid(blockState);
    }

    @Override
    @Nullable
    public TreeData gatherTreeData(@NotNull class_2338 blockPos, @NotNull class_1937 level, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2338 blockPos2 = blockPos;
        if (this.getConfig().getRequireTool()) {
            TreeConfig.Filter filter = this.getConfig().getAllowedToolFilter();
            class_1799 class_17992 = player.method_6047();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getMainHandItem(...)");
            if (!filter.isValid(class_17992)) {
                return null;
            }
        }
        class_2338 class_23382 = blockPos2.method_10062();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"immutable(...)");
        blockPos2 = class_23382;
        TreeData.Builder builder = new TreeData.Builder();
        List blocks = new ArrayList();
        this.gatherBlocks(level, blockPos2, blocks);
        List drops = new ArrayList();
        if (level instanceof class_3218) {
            for (class_2338 block : blocks) {
                class_2680 blockState = ((class_3218)level).method_8320(block);
                List items = class_2248.method_9609((class_2680)blockState, (class_3218)((class_3218)level), (class_2338)block, null, (class_1297)((class_1297)player), (class_1799)player.method_6047());
                Intrinsics.checkNotNull((Object)items);
                drops.addAll(items);
            }
        }
        TreeData.Builder builder2 = builder.addBlocks(blocks).setToolDamage(blocks.size()).setFoodExhaustionModifier(arg_0 -> VerticalTree.gatherTreeData$lambda$0(blocks, arg_0)).addDrops(drops).setMiningSpeedModifier(arg_0 -> VerticalTree.gatherTreeData$lambda$1(blocks, arg_0));
        List<class_3445> list = blocks.stream().map(arg_0 -> VerticalTree.gatherTreeData$lambda$3(arg_0 -> VerticalTree.gatherTreeData$lambda$2(level, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return builder2.addAwardedStats((Collection)list).build();
    }

    private final void gatherBlocks(class_1937 level, class_2338 blockPos, List<class_2338> blocks) {
        class_2680 blockState = level.method_8320(blockPos);
        blocks.add(blockPos);
        class_2338 neighborPos = blockPos.method_10084();
        if (level.method_8320(neighborPos).method_27852(blockState.method_26204())) {
            Intrinsics.checkNotNull((Object)neighborPos);
            this.gatherBlocks(level, neighborPos, blocks);
        }
    }

    @Override
    public void onTreeTick(@NotNull TreeEntity entity) {
        TreeType.super.onTreeTick(entity);
    }

    private static final float gatherTreeData$lambda$0(List $blocks, float originalExhaustion) {
        return originalExhaustion * (float)$blocks.size();
    }

    private static final float gatherTreeData$lambda$1(List $blocks, float originalMiningSpeed) {
        float speedMultiplication = ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getSpeedMultiplication();
        float multiplyAmount = RangesKt.coerceAtMost((float)((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getMaxSpeedMultiplication(), (float)((float)$blocks.size() - 1.0f));
        return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
    }

    private static final class_3445 gatherTreeData$lambda$2(class_1937 $level, class_2338 logPos) {
        Intrinsics.checkNotNullParameter((Object)logPos, (String)"logPos");
        class_2680 blockState = $level.method_8320(logPos);
        return class_3468.field_15427.method_14956((Object)blockState.method_26204());
    }

    private static final class_3445 gatherTreeData$lambda$3(Function1 $tmp0, Object p0) {
        return (class_3445)$tmp0.invoke(p0);
    }
}

