/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.stream.Stream;

public final class SoundsKey
extends Record {
    private final String raw;
    private final String[] names;
    private static final Interner<SoundsKey> INTERNER = Interners.newWeakInterner();
    public static final SoundsKey UNASSIGNED = (SoundsKey)INTERNER.intern((Object)new SoundsKey("UNASSIGNED", new String[0]));
    public static final SoundsKey NON_EMITTER = (SoundsKey)INTERNER.intern((Object)new SoundsKey("NOT_EMITTER", new String[0]));
    public static final SoundsKey MESSY_GROUND = (SoundsKey)INTERNER.intern((Object)new SoundsKey("MESSY_GROUND", new String[0]));
    public static final SoundsKey VANILLA = (SoundsKey)INTERNER.intern((Object)new SoundsKey("VANILLA", new String[0]));
    public static final SoundsKey SWIM_WATER = SoundsKey.of("swim_water");
    public static final SoundsKey SWIM_LAVA = SoundsKey.of("swim_lava");
    public static final SoundsKey WATERFINE = SoundsKey.of("waterfine");
    public static final SoundsKey LAVAFINE = SoundsKey.of("lavafine");

    SoundsKey(String names) {
        String[] stringArray;
        if (names.indexOf(44) == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = names;
        } else {
            stringArray = (String[])Stream.of(names.split(",")).filter(s -> !s.isEmpty()).distinct().toArray(String[]::new);
        }
        this(names, stringArray);
    }

    public SoundsKey(String raw, String[] names) {
        this.raw = raw;
        this.names = names;
    }

    public static SoundsKey of(String names) {
        if (MESSY_GROUND.raw().equalsIgnoreCase(names)) {
            return MESSY_GROUND;
        }
        if (UNASSIGNED.raw().equalsIgnoreCase(names)) {
            return UNASSIGNED;
        }
        if (NON_EMITTER.raw().equalsIgnoreCase(names)) {
            return NON_EMITTER;
        }
        if (VANILLA.raw().equalsIgnoreCase(names)) {
            return VANILLA;
        }
        return (SoundsKey)INTERNER.intern((Object)new SoundsKey(names.toLowerCase(Locale.ROOT)));
    }

    public boolean isResult() {
        return this != UNASSIGNED;
    }

    public boolean isSilent() {
        return this == NON_EMITTER;
    }

    public boolean isVanilla() {
        return this == VANILLA;
    }

    public boolean isEmitter() {
        return !this.isSilent();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SoundsKey.class, "raw;names", "raw", "names"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SoundsKey.class, "raw;names", "raw", "names"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SoundsKey.class, "raw;names", "raw", "names"}, this, o);
    }

    public String raw() {
        return this.raw;
    }

    public String[] names() {
        return this.names;
    }
}

