/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.impl;

import com.google.common.base.Joiner;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.ModifiableControllerState;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public class ControllerStateImpl
implements ModifiableControllerState {
    private final Map<class_2960, Boolean> buttons = new Object2BooleanArrayMap();
    private final Map<class_2960, Float> axes = new Object2FloatArrayMap();
    private final Map<class_2960, Float> restingAxes = new Object2FloatArrayMap();
    private final Map<class_2960, HatState> hats = new Object2ObjectArrayMap();

    @Override
    public boolean isButtonDown(class_2960 button) {
        return this.buttons.getOrDefault(button, false);
    }

    @Override
    public Set<class_2960> getButtons() {
        return this.buttons.keySet();
    }

    @Override
    public float getAxisState(class_2960 axis) {
        return this.axes.getOrDefault(axis, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Set<class_2960> getAxes() {
        return this.axes.keySet();
    }

    @Override
    public float getAxisResting(class_2960 axis) {
        return this.restingAxes.getOrDefault(axis, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public HatState getHatState(class_2960 hat) {
        return this.hats.getOrDefault(hat, HatState.CENTERED);
    }

    @Override
    public Set<class_2960> getHats() {
        return this.hats.keySet();
    }

    @Override
    public void setButton(class_2960 button, boolean value) {
        this.buttons.put(button, value);
    }

    @Override
    public void setAxis(class_2960 axis, float value) {
        this.axes.put(axis, Float.valueOf(value));
    }

    public void setRestingAxis(class_2960 axis, float value) {
        if (!this.axes.containsKey(axis)) {
            throw new IllegalArgumentException("Cannot set resting axis for axis that doesn't exist");
        }
        this.restingAxes.put(axis, Float.valueOf(value));
    }

    @Override
    public void setHat(class_2960 hat, HatState value) {
        this.hats.put(hat, value);
    }

    @Override
    public void clearState() {
        this.buttons.clear();
        this.axes.clear();
        this.restingAxes.clear();
        this.hats.clear();
    }

    public String toDebugString() {
        Joiner.MapJoiner joiner = Joiner.on((String)",").withKeyValueSeparator("=");
        return "ControllerState{axes:%s,buttons:%s,hats:%s}".formatted(joiner.join(this.axes), joiner.join(this.buttons), joiner.join(this.hats));
    }
}

