/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs.yacl;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.awt.Color;
import java.util.function.Supplier;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigEntry;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigSubCategory;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.FabricConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.BoolConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.ColorConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.DoubleConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.EnumConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.IntConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.StringConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class YACLCompat {
    public static final ValueFormatter<Double> DEFAULT_FORMATTER = value -> class_2561.method_30163((String)String.format("%,.4f", value).replaceAll("[\u00a0\u202f]", " "));

    public static class_437 makeScreen(class_437 parent, FabricConfigSpec spec) {
        return YACLCompat.makeScreen(parent, spec, null);
    }

    public static class_437 makeScreen(class_437 parent, FabricConfigSpec spec, @Nullable class_2960 background) {
        spec.forceLoad();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder();
        builder.title(spec.getReadableName());
        builder.save(spec::saveConfig);
        for (ConfigEntry en : spec.getMainEntry().getEntries()) {
            if (!(en instanceof ConfigSubCategory)) continue;
            ConfigSubCategory c = (ConfigSubCategory)en;
            ConfigCategory.Builder mainCat = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)c.getName()));
            for (ConfigEntry entry : c.getEntries()) {
                if (entry instanceof ConfigSubCategory) {
                    ConfigSubCategory subCat = (ConfigSubCategory)entry;
                    OptionGroup.Builder subBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)subCat.getName())).collapsed(true);
                    YACLCompat.addEntriesRecursive(mainCat, subBuilder, subCat);
                    mainCat.group(subBuilder.build());
                    continue;
                }
                mainCat.option(YACLCompat.buildEntry(entry));
            }
            builder.category(mainCat.build());
        }
        return builder.build().generateScreen(parent);
    }

    private static void addEntriesRecursive(ConfigCategory.Builder builder, OptionGroup.Builder subCategoryBuilder, ConfigSubCategory c) {
        for (ConfigEntry entry : c.getEntries()) {
            if (entry instanceof ConfigSubCategory) {
                ConfigSubCategory cc = (ConfigSubCategory)entry;
                OptionGroup.Builder scb = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)entry.getName())).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Unsupported")}));
                YACLCompat.addEntriesRecursive(builder, subCategoryBuilder, cc);
                continue;
            }
            subCategoryBuilder.option(YACLCompat.buildEntry(entry));
        }
    }

    private static Option<?> buildEntry(ConfigEntry entry) {
        if (entry instanceof ColorConfigValue) {
            ColorConfigValue col = (ColorConfigValue)entry;
            Option.Builder e = Option.createBuilder(Color.class).name(col.getTranslation()).binding((Object)new Color((Integer)col.getDefaultValue()), () -> new Color((Integer)col.get()), v -> col.set(v.getRGB())).controller(o -> ColorControllerBuilder.create((Option)o).allowAlpha(true));
            class_2561 description = col.getDescription();
            if (description != null) {
                e.description(OptionDescription.of((class_2561[])new class_2561[]{description}));
            }
            return e.build();
        }
        if (entry instanceof IntConfigValue) {
            IntConfigValue ic = (IntConfigValue)entry;
            Option.Builder e = Option.createBuilder(Integer.class).name(ic.getTranslation()).binding((Object)((Integer)ic.getDefaultValue()), (Supplier)ic, ic::set).controller(o -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)o).range((Number)ic.getMin(), (Number)ic.getMax())).step((Number)1));
            class_2561 description = ic.getDescription();
            if (description != null) {
                e.description(OptionDescription.of((class_2561[])new class_2561[]{description}));
            }
            return e.build();
        }
        if (entry instanceof DoubleConfigValue) {
            DoubleConfigValue dc = (DoubleConfigValue)entry;
            Option.Builder e = Option.createBuilder().name(dc.getTranslation()).binding((Object)((Double)dc.getDefaultValue()), (Supplier)dc, dc::set).controller(o -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)o).range((Number)dc.getMin(), (Number)dc.getMax())).step((Number)1.0E-4)).formatValue(DEFAULT_FORMATTER));
            class_2561 description = dc.getDescription();
            if (description != null) {
                e.description(OptionDescription.of((class_2561[])new class_2561[]{description}));
            }
            return e.build();
        }
        if (entry instanceof StringConfigValue) {
            StringConfigValue sc = (StringConfigValue)entry;
            Option.Builder e = Option.createBuilder(String.class).name(sc.getTranslation()).binding((Object)((String)sc.getDefaultValue()), (Supplier)sc, sc::set).controller(StringControllerBuilder::create);
            class_2561 description = sc.getDescription();
            if (description != null) {
                e.description(OptionDescription.of((class_2561[])new class_2561[]{description}));
            }
            return e.build();
        }
        if (entry instanceof BoolConfigValue) {
            BoolConfigValue bc = (BoolConfigValue)entry;
            Option.Builder e = Option.createBuilder().name(bc.getTranslation()).binding((Object)((Boolean)bc.getDefaultValue()), (Supplier)bc, bc::set).controller(TickBoxControllerBuilder::create);
            class_2561 description = bc.getDescription();
            if (description != null) {
                e.description(OptionDescription.of((class_2561[])new class_2561[]{description}));
            }
            return e.build();
        }
        if (entry instanceof EnumConfigValue) {
            EnumConfigValue ec = (EnumConfigValue)entry;
            return YACLCompat.addEnum(ec);
        }
        throw new UnsupportedOperationException("unknown entry: " + entry.getClass().getName());
    }

    private static <T extends Enum<T>> Option<T> addEnum(EnumConfigValue<T> ec) {
        Option.Builder e = Option.createBuilder(ec.getEnumClass()).name(ec.getTranslation()).binding((Object)((Enum)ec.getDefaultValue()), ec, ec::set).controller(EnumControllerBuilder::create);
        class_2561 description = ec.getDescription();
        if (description != null) {
            e.description(OptionDescription.of((class_2561[])new class_2561[]{description}));
        }
        return e.build();
    }
}

