/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.frozenblock.lib.block.sound.impl.BlockSoundTypeManager;
import net.frozenblock.lib.cape.client.impl.ClientCapeData;
import net.frozenblock.lib.core.client.api.PanoramaCommand;
import net.frozenblock.lib.entrypoint.api.FrozenClientEntrypoint;
import net.frozenblock.lib.integration.api.ModIntegrations;
import net.frozenblock.lib.networking.FrozenClientNetworking;
import net.frozenblock.lib.particle.client.resource.FrozenLibParticleResources;
import net.frozenblock.lib.registry.client.FrozenLibClientRegistries;
import net.frozenblock.lib.resource_pack.api.client.FrozenLibModResourcePackApi;
import net.frozenblock.lib.screenshake.api.client.ScreenShaker;
import net.frozenblock.lib.sound.client.impl.FlyBySoundHub;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.lib.worldgen.structure.api.status.client.ClientStructureStatuses;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client.ClientRegistrySync;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.client.ClientFreezer;

public final class FrozenLibClient
implements ClientModInitializer {
    public void onInitializeClient() {
        FrozenLibClientRegistries.initRegistry();
        ModIntegrations.initializePreFreeze();
        ClientFreezer.onInitializeClient();
        ClientRegistrySync.registerHandlers();
        FrozenLibClient.registerClientEvents();
        FrozenClientNetworking.registerClientReceivers();
        ClientCapeData.init();
        FrozenLibParticleResources.init();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, buildContext) -> PanoramaCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        FrozenLibModResourcePackApi.init();
        ResourceManagerHelper resourceLoader = ResourceManagerHelper.get((class_3264)class_3264.field_14188);
        resourceLoader.registerReloadListener((IdentifiableResourceReloadListener)BlockSoundTypeManager.INSTANCE);
        ((FrozenClientEntrypoint)FrozenClientEntrypoint.EVENT.invoker()).init();
    }

    private static void registerClientEvents() {
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            ClientWindManager.tick(world);
            ScreenShaker.tick(world);
            FlyBySoundHub.tick(class_310.method_1551(), class_310.method_1551().method_1560(), true);
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> ClientWindManager.clearAndSwitchWindDisturbances());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> FrozenLibClient.clearClientListHolders());
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((minecraft, clientLevel) -> FrozenLibClient.clearClientListHolders());
    }

    private static void clearClientListHolders() {
        ScreenShaker.clear();
        ClientWindManager.reset();
        ClientStructureStatuses.clearStructureStatuses();
    }
}

