/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class IncompatibleMod {
    private final String jarNamePart;
    private final String modId;
    private final String explainMessage;
    private final List<Mod> detectedMods = new ArrayList<Mod>();
    public static final HashSet<IncompatibleMod> incompatibleMods = new HashSet<IncompatibleMod>(){
        {
            this.add(new IncompatibleMod("crashdetector", "crashdetector", "These mods perform very similar functions and are implemented in very similar ways.\nThere is no reason to have both. Please remove one of them.\nBoth mods consume RAM and system resources, and both display GUIs after a crash.\nIt can be inconvenient to have multiple crash screens appear after a crash - from Crash Assistant, Crash Detector, launcher, etc.\nWe (Crash Assistant developers) are aware of crashes caused by compatibility issues,\nbut we have no intention of fixing them as there is too much drama involved.\nAs mentioned above, since the mods have very similar functionality and concepts,\nthere's no reason to have both. Please read the descriptions of both and choose the one that better suits your needs.\nYou can disable the compatibility check in the Crash Assistant config, but be aware that you have been warned about potential issues and inconveniences!"));
        }
    };

    public IncompatibleMod(String jarNamePart, String modId, String explainMessage) {
        this.jarNamePart = jarNamePart;
        this.modId = modId;
        this.explainMessage = explainMessage;
    }

    public String getJarNamePart() {
        return this.jarNamePart;
    }

    public String getModId() {
        return this.modId;
    }

    public String getExplainMessage() {
        return this.explainMessage;
    }

    public List<Mod> getDetectedMods() {
        return this.detectedMods;
    }

    public void addDetectedMod(Mod mod) {
        this.detectedMods.add(mod);
    }

    public void addDetectedMods(List<Mod> mods) {
        this.detectedMods.addAll(mods);
    }
}

