/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModpackStatus;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModpackStatusChecker {
    private static ModpackStatusChecker instance;
    private final Map<String, Mod> currentModsById;
    private final Map<String, Mod> currentModsByJarName;
    private final Map<String, Mod> savedModsById;
    private final Map<String, Mod> savedModsByJarName;
    private final Map<String, Mod> jijRootContainerMap;
    private final boolean isEnabled = CrashAssistantConfig.getBoolean("modpack_modlist.enabled");
    private final boolean hasSavedData;

    private ModpackStatusChecker() {
        this.currentModsById = new HashMap<String, Mod>();
        this.currentModsByJarName = new HashMap<String, Mod>();
        this.savedModsById = new HashMap<String, Mod>();
        this.savedModsByJarName = new HashMap<String, Mod>();
        this.jijRootContainerMap = new HashMap<String, Mod>();
        if (this.isEnabled) {
            LinkedHashSet<Mod> savedList;
            LinkedHashSet<Mod> currentList = ModListUtils.getCurrentModList(true);
            if (currentList != null) {
                for (Mod rootMod : currentList) {
                    if (rootMod.getModId() != null) {
                        this.currentModsById.put(rootMod.getModId(), rootMod);
                    }
                    if (rootMod.getJarName() != null) {
                        this.currentModsByJarName.put(rootMod.getJarName(), rootMod);
                    }
                    this.mapChildrenToRoot(rootMod, rootMod);
                }
            }
            boolean bl = this.hasSavedData = (savedList = ModListUtils.getSavedModList()) != null && !savedList.isEmpty();
            if (this.hasSavedData) {
                for (Mod mod : savedList) {
                    if (mod.getModId() != null) {
                        this.savedModsById.put(mod.getModId(), mod);
                    }
                    if (mod.getJarName() == null) continue;
                    this.savedModsByJarName.put(mod.getJarName(), mod);
                }
            }
        } else {
            this.hasSavedData = false;
        }
    }

    private void mapChildrenToRoot(Mod current, Mod rootContainer) {
        List<Mod> children = current.getJarJarMods();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (Mod child : children) {
            if (child.getModId() != null) {
                this.currentModsById.put(child.getModId(), child);
                this.jijRootContainerMap.put(child.getModId(), rootContainer);
            }
            this.mapChildrenToRoot(child, rootContainer);
        }
    }

    private static synchronized ModpackStatusChecker getInstance() {
        if (instance == null) {
            instance = new ModpackStatusChecker();
        }
        return instance;
    }

    public static ModpackStatus getStatusById(String modId) {
        if (modId == null) {
            return ModpackStatus.UNKNOWN;
        }
        return ModpackStatusChecker.getInstance().resolveStatusById(modId);
    }

    public static ModpackStatus getStatusByFileName(String jarName) {
        if (jarName == null) {
            return ModpackStatus.UNKNOWN;
        }
        return ModpackStatusChecker.getInstance().resolveStatusByFileName(jarName);
    }

    private ModpackStatus resolveStatusById(String modId) {
        if (!this.isEnabled || !this.hasSavedData) {
            return ModpackStatus.UNKNOWN;
        }
        Mod currentMod = this.currentModsById.get(modId);
        if (currentMod == null) {
            if (this.savedModsById.containsKey(modId)) {
                return ModpackStatus.REMOVED;
            }
            return ModpackStatus.UNKNOWN;
        }
        Mod rootContainer = this.jijRootContainerMap.get(modId);
        if (rootContainer != null) {
            return this.resolveJarInJarStatus(rootContainer);
        }
        Mod savedMod = this.savedModsById.get(modId);
        if (savedMod == null) {
            return ModpackStatus.ADDED;
        }
        if (Objects.equals(currentMod.getVersion(), savedMod.getVersion())) {
            return ModpackStatus.UNCHANGED;
        }
        return ModpackStatus.UPDATED;
    }

    private ModpackStatus resolveStatusByFileName(String jarName) {
        if (!this.isEnabled || !this.hasSavedData) {
            return ModpackStatus.UNKNOWN;
        }
        Mod currentMod = this.currentModsByJarName.get(jarName);
        Mod savedMod = this.savedModsByJarName.get(jarName);
        if (currentMod == null) {
            if (savedMod != null) {
                return ModpackStatus.REMOVED;
            }
            return ModpackStatus.UNKNOWN;
        }
        if (savedMod == null) {
            return ModpackStatus.ADDED;
        }
        if (Objects.equals(currentMod.getVersion(), savedMod.getVersion())) {
            return ModpackStatus.UNCHANGED;
        }
        return ModpackStatus.UPDATED;
    }

    private ModpackStatus resolveJarInJarStatus(Mod currentRootContainer) {
        Mod savedParent = null;
        if (currentRootContainer.getModId() != null) {
            savedParent = this.savedModsById.get(currentRootContainer.getModId());
        }
        if (savedParent == null && currentRootContainer.getJarName() != null) {
            savedParent = this.savedModsByJarName.get(currentRootContainer.getJarName());
        }
        if (savedParent == null) {
            return ModpackStatus.ADDED;
        }
        if (Objects.equals(savedParent.getVersion(), currentRootContainer.getVersion())) {
            return ModpackStatus.UNCHANGED;
        }
        return ModpackStatus.UPDATED;
    }
}

