/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc.iroh;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import link.e4mc.iroh.Connection;
import link.e4mc.iroh.DeferredInitializer;
import link.e4mc.iroh.Endpoint;
import link.e4mc.iroh.Resolvable;
import link.e4mc.iroh.Stream;

public class Native {
    private static void loadNativeLibrary() {
        Object libName = "iroh_java";
        libName = (String)libName + "_" + PlatformDependent.normalizedOs() + "_" + PlatformDependent.normalizedArch() + "_278c6cb";
        Object libraryPath = System.getProperty("link.e4mc.dialtone.native_path");
        boolean downloaded = false;
        while (libraryPath == null) {
            String home = System.getProperty("user.home");
            String fileName = System.mapLibraryName((String)libName);
            String folderPath = home + File.separatorChar + ".e4mc_cache";
            libraryPath = folderPath + File.separatorChar + fileName;
            new File(folderPath).mkdirs();
            if (!new File((String)libraryPath).isFile()) {
                try {
                    URL url = new URL(System.getProperty("link.e4mc.dialtone.native_url", "https://natives.e4mc.link/" + fileName));
                    ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                    FileOutputStream fos = new FileOutputStream((String)libraryPath);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    fos.close();
                    rbc.close();
                    downloaded = true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Path tempDir = Files.createTempDirectory("e4mc_temp", new FileAttribute[0]);
                tempDir.toFile().deleteOnExit();
                FileInputStream fis = new FileInputStream((String)libraryPath);
                byte[] buf = new byte[fis.available()];
                fis.read(buf);
                fis.close();
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hashed = digest.digest(buf);
                byte[] expected = Native.get_native_hash(fileName);
                if (!Arrays.equals(hashed, expected)) {
                    if (downloaded) {
                        throw new RuntimeException("Could not download a valid native!");
                    }
                    Files.delete(Paths.get((String)libraryPath, new String[0]));
                    libraryPath = null;
                    continue;
                }
                Path tempFile = tempDir.resolve(fileName);
                FileOutputStream fos = new FileOutputStream(tempFile.toString());
                fos.write(buf);
                fos.close();
                libraryPath = tempFile.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        System.load((String)libraryPath);
    }

    private static byte[] get_native_hash(String filename) {
        switch (filename) {
            case "iroh_java_windows_x86_64_278c6cb.dll": {
                return new byte[]{-108, 126, 115, 123, -49, -23, 92, -77, 111, -83, -32, 40, 49, 92, 66, 37, -25, -119, -25, -77, -97, 23, -109, 11, -77, -16, 51, 116, 74, 83, 36, 78};
            }
            case "libiroh_java_linux_aarch_64_278c6cb.so": {
                return new byte[]{27, 25, 73, 43, 57, 115, -26, -102, -111, -71, 113, 81, -46, 17, -71, 5, 60, 108, 109, -105, -45, 64, 53, -45, -111, 32, -68, 53, -66, -74, 16, 10};
            }
            case "libiroh_java_linux_x86_64_278c6cb.so": {
                return new byte[]{-25, 81, -5, 61, 78, -30, 50, -38, 20, -9, -34, -89, 126, -30, 100, 27, -98, -87, 3, 101, -41, 107, 110, -52, 45, -85, -31, -110, -73, -94, 68, 66};
            }
            case "libiroh_java_osx_aarch_64_278c6cb.dylib": {
                return new byte[]{-41, -80, 87, -40, -94, -42, 51, 104, 93, 126, 68, -101, -16, -30, -110, -119, -114, -120, -122, -22, -111, -36, 121, 39, 22, 17, -106, 14, -70, -35, 11, -40};
            }
            case "libiroh_java_osx_x86_64_278c6cb.dylib": {
                return new byte[]{-77, 41, -74, -124, -105, 101, -125, 73, -28, -64, -12, -76, 9, 53, 114, 13, 80, -113, -88, -1, -22, -54, -21, 79, -125, 66, 121, -63, 22, -73, -68, -45};
            }
        }
        return new byte[0];
    }

    static native Object resolveDeferredInitializer(DeferredInitializer<?> var0);

    static native void initEndpointBundle(Endpoint var0, byte[][] var1, String[] var2);

    static native void freeEndpointBundle(Endpoint var0);

    static native Runnable pollEndpointBundle(Endpoint var0);

    static native String addrEndpointBundle(Endpoint var0);

    static native void watchAddrEndpointBundle(Endpoint var0, Resolvable<String> var1);

    static native void onlineEndpointBundle(Endpoint var0, Resolvable<String> var1);

    static native void closeEndpointBundle(Endpoint var0, Resolvable<Void> var1);

    static native void acceptEndpointBundle(Endpoint var0, Resolvable<Void> var1, Resolvable<Connection> var2);

    static native void connectEndpointBundle(Endpoint var0, String var1, byte[] var2, Resolvable<Connection> var3);

    static native void closeIrohConnection(Connection var0, long var1, byte[] var3);

    static native String addrIrohConnection(Connection var0);

    static native byte[] exportKeyingMaterialIrohConnection(Connection var0, byte[] var1, byte[] var2, int var3);

    static native void acceptBiIrohConnection(Connection var0, Resolvable<Stream> var1);

    static native void acceptUniIrohConnection(Connection var0, Resolvable<Stream> var1);

    static native void openBiIrohConnection(Connection var0, Resolvable<Stream> var1);

    static native void openUniIrohConnection(Connection var0, Resolvable<Stream> var1);

    static native void readIrohStreamByteBuffer(Stream var0, ByteBuffer var1, long var2, long var4, Resolvable<Long> var6);

    static native void readIrohStreamByteArray(Stream var0, long var1, Resolvable<byte[]> var3);

    static native void writeIrohStreamByteBuffer(Stream var0, ByteBuffer var1, long var2, long var4, Resolvable<Void> var6);

    static native void writeIrohStreamByteArray(Stream var0, byte[] var1, long var2, long var4, Resolvable<Void> var6);

    static native void freeIrohStream(Stream var0);

    static native String sanitizeTicket(String var0);

    static {
        Native.loadNativeLibrary();
    }
}

