/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.codecs.stream;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_8703;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CatnipStreamCodecBuilders {
    public static <T extends ByteBuf, S extends Enum<S>> class_9139<T, S> ofEnum(final Class<S> clazz) {
        return new class_9139<T, S>(){

            @NotNull
            public S decode(@NotNull T buffer) {
                return ((Enum[])clazz.getEnumConstants())[class_8703.method_53016(buffer)];
            }

            public void encode(@NotNull T buffer, @NotNull S value) {
                class_8703.method_53017(buffer, (int)((Enum)value).ordinal());
            }
        };
    }

    public static <B extends ByteBuf, L, R> class_9139<B, Pair<L, R>> pair(final class_9139<B, L> codecL, final class_9139<B, R> codecR) {
        return new class_9139<B, Pair<L, R>>(){

            @NotNull
            public Pair<L, R> decode(B buffer) {
                Object l = codecL.decode(buffer);
                Object r = codecR.decode(buffer);
                return Pair.of((Object)l, (Object)r);
            }

            public void encode(B buffer, Pair<L, R> value) {
                codecL.encode(buffer, value.getFirst());
                codecR.encode(buffer, value.getSecond());
            }
        };
    }

    public static <B extends class_2540, V> class_9139.class_9140<B, V, Optional<V>> optional() {
        return class_9135::method_56382;
    }

    public static <B extends ByteBuf, V> class_9139<B, @Nullable V> nullable(final class_9139<B, V> base) {
        return new class_9139<B, V>(){

            @Nullable
            public V decode(@NotNull B buffer) {
                return class_2540.method_56893(buffer, (class_9141)base);
            }

            public void encode(@NotNull B buffer, @Nullable V value) {
                class_2540.method_56892(buffer, value, (class_9142)base);
            }
        };
    }

    public static <B extends class_2540, V> // Could not load outer class - annotation placement on inner may be incorrect
    class_9139.class_9140<B, V, @Nullable V> nullable() {
        return CatnipStreamCodecBuilders::nullable;
    }

    public static <B extends ByteBuf, V> class_9139<B, List<V>> list(class_9139<B, V> base) {
        return base.method_56433(class_9135.method_56363());
    }

    public static <B extends class_2540, V> class_9139<B, List<V>> list(class_9139<B, V> base, int maxSize) {
        return base.method_56433(class_9135.method_58000((int)maxSize));
    }

    public static <B extends class_2540, V> class_9139.class_9140<B, V, class_2371<V>> nonNullList() {
        return streamCodec -> class_9135.method_56376(class_2371::method_37434, (class_9139)streamCodec);
    }

    public static <B extends class_2540, V> class_9139.class_9140<B, V, class_2371<V>> nonNullList(int maxSize) {
        return streamCodec -> class_9135.method_57991(class_2371::method_37434, (class_9139)streamCodec, (int)maxSize);
    }

    public static <B extends class_2540, V> class_9139<B, class_2371<V>> nonNullList(class_9139<B, V> base) {
        return base.method_56433(CatnipStreamCodecBuilders.nonNullList());
    }

    public static <B extends class_2540, V> class_9139<B, class_2371<V>> nonNullList(class_9139<B, V> base, int maxSize) {
        return base.method_56433(CatnipStreamCodecBuilders.nonNullList(maxSize));
    }

    public static <B extends class_2540, V> class_9139<B, V[]> array(final class_9139<? super B, V> base, final Class<?> clazz) {
        return new class_9139<B, V[]>(){

            public V @NotNull [] decode(@NotNull B buffer) {
                int size = buffer.method_10816();
                Object[] array = (Object[])Array.newInstance(clazz, size);
                for (int i = 0; i < size; ++i) {
                    array[i] = base.decode(buffer);
                }
                return array;
            }

            public void encode(@NotNull B buffer, @NotNull V[] value) {
                buffer.method_10804(value.length);
                for (Object v : value) {
                    base.encode(buffer, v);
                }
            }
        };
    }

    public static <B extends class_2540, V> class_9139.class_9140<B, V, V[]> array(Class<?> clazz) {
        return streamCodec -> CatnipStreamCodecBuilders.array(streamCodec, clazz);
    }

    public static <T> class_9139<ByteBuf, class_6862<T>> tagKey(class_5321<? extends class_2378<T>> registry) {
        return class_2960.field_48267.method_56432(id -> class_6862.method_40092((class_5321)registry, (class_2960)id), class_6862::comp_327);
    }
}

