/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.data;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class Couple<T>
extends Pair<T, T>
implements Iterable<T> {
    private static final Couple<Boolean> TRUE_AND_FALSE = Couple.create(true, false);

    protected Couple(T first, T second) {
        super(first, second);
    }

    public static <T> Couple<T> create(T first, T second) {
        return new Couple<T>(first, second);
    }

    public static <T> Couple<T> create(Supplier<T> factory) {
        return new Couple<T>(factory.get(), factory.get());
    }

    public static <T> Couple<T> createWithContext(Function<Boolean, T> factory) {
        return new Couple<T>(factory.apply(true), factory.apply(false));
    }

    public static <S> Couple<S> deserializeEach(class_2499 list, Function<class_2487, S> deserializer) {
        List<S> readCompoundList = NBTHelper.readCompoundList(list, deserializer);
        return new Couple<S>(readCompoundList.get(0), readCompoundList.get(1));
    }

    public static <T> Codec<Couple<T>> codec(final Codec<T> codec) {
        return new Codec<Couple<T>>(){

            public <V> DataResult<com.mojang.datafixers.util.Pair<Couple<T>, V>> decode(DynamicOps<V> ops, V input) {
                return (DataResult)ops.getStream(input).mapOrElse(stream -> {
                    Iterator iterator = stream.iterator();
                    if (!iterator.hasNext()) {
                        return DataResult.error(() -> "size error");
                    }
                    DataResult first = codec.parse(ops, iterator.next());
                    if (first.isError()) {
                        return first.map(i -> null);
                    }
                    if (!iterator.hasNext()) {
                        return DataResult.error(() -> "size error");
                    }
                    DataResult second = codec.parse(ops, iterator.next());
                    if (second.isError()) {
                        return second.map(i -> null);
                    }
                    return DataResult.success((Object)com.mojang.datafixers.util.Pair.of(new Couple<Object>(first.getOrThrow(), second.getOrThrow()), (Object)ops.empty()));
                }, e -> e.map(i -> null));
            }

            public <V> DataResult<V> encode(Couple<T> input, DynamicOps<V> ops, V prefix) {
                ListBuilder list = ops.listBuilder();
                list.add(input.first, (Encoder)codec);
                list.add(input.second, (Encoder)codec);
                return list.build(prefix);
            }
        };
    }

    public static <T> Codec<Couple<Optional<T>>> optionalCodec(final Codec<T> codec) {
        return new Codec<Couple<Optional<T>>>(){

            public <V> DataResult<com.mojang.datafixers.util.Pair<Couple<Optional<T>>, V>> decode(DynamicOps<V> ops, V input) {
                return (DataResult)ops.getMap(input).mapOrElse(map -> {
                    Optional first = Optional.ofNullable(map.get("first")).flatMap(i -> codec.parse(ops, i).result());
                    Optional second = Optional.ofNullable(map.get("second")).flatMap(i -> codec.parse(ops, i).result());
                    return DataResult.success((Object)com.mojang.datafixers.util.Pair.of(new Couple(first, second), (Object)ops.empty()));
                }, e -> DataResult.success((Object)com.mojang.datafixers.util.Pair.of(Couple.create(Optional::empty), (Object)ops.empty())));
            }

            public <V> DataResult<V> encode(Couple<Optional<T>> input, DynamicOps<V> ops, V prefix) {
                RecordBuilder map = ops.mapBuilder();
                ((Optional)input.getFirst()).ifPresent(first -> map.add("first", first, (Encoder)codec));
                ((Optional)input.getSecond()).ifPresent(second -> map.add("second", second, (Encoder)codec));
                return map.build(prefix);
            }
        };
    }

    public static <B, T> class_9139<B, Couple<T>> streamCodec(class_9139<? super B, T> codec) {
        return class_9139.method_56435(codec, Pair::getFirst, codec, Pair::getSecond, Couple::new);
    }

    public T get(boolean first) {
        return (T)(first ? this.getFirst() : this.getSecond());
    }

    public void set(boolean first, T value) {
        if (first) {
            this.setFirst(value);
        } else {
            this.setSecond(value);
        }
    }

    public Couple<T> copy() {
        return Couple.create(this.first, this.second);
    }

    public <S> Couple<S> map(Function<T, S> function) {
        return Couple.create(function.apply(this.first), function.apply(this.second));
    }

    public <S> Couple<S> mapNotNull(Function<T, S> function) {
        return Couple.create(this.first != null ? (T)function.apply(this.first) : null, this.second != null ? (T)function.apply(this.second) : null);
    }

    public <S> Couple<S> mapWithContext(BiFunction<T, Boolean, S> function) {
        return Couple.create(function.apply(this.first, true), function.apply(this.second, false));
    }

    public <S, R> Couple<S> mapWithParams(BiFunction<T, R, S> function, Couple<R> values) {
        return Couple.create(function.apply(this.first, values.first), function.apply(this.second, values.second));
    }

    public <S, R> Couple<S> mapNotNullWithParam(BiFunction<T, R, S> function, R value) {
        return Couple.create(this.first != null ? (T)function.apply(this.first, value) : null, this.second != null ? (T)function.apply(this.second, value) : null);
    }

    public boolean both(Predicate<T> test) {
        return test.test(this.getFirst()) && test.test(this.getSecond());
    }

    public boolean either(Predicate<T> test) {
        return test.test(this.getFirst()) || test.test(this.getSecond());
    }

    public void replace(Function<T, T> function) {
        this.setFirst(function.apply(this.getFirst()));
        this.setSecond(function.apply(this.getSecond()));
    }

    public void replaceWithContext(BiFunction<T, Boolean, T> function) {
        this.replaceWithParams(function, TRUE_AND_FALSE);
    }

    public <S> void replaceWithParams(BiFunction<T, S, T> function, Couple<S> values) {
        this.setFirst(function.apply(this.getFirst(), values.getFirst()));
        this.setSecond(function.apply(this.getSecond(), values.getSecond()));
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        consumer.accept(this.getFirst());
        consumer.accept(this.getSecond());
    }

    public void forEachWithContext(BiConsumer<T, Boolean> consumer) {
        this.forEachWithParams(consumer, TRUE_AND_FALSE);
    }

    public <S> void forEachWithParams(BiConsumer<T, S> function, Couple<S> values) {
        function.accept(this.getFirst(), values.getFirst());
        function.accept(this.getSecond(), values.getSecond());
    }

    public Couple<T> swap() {
        return Couple.create(this.second, this.first);
    }

    public class_2499 serializeEach(Function<T, class_2487> serializer) {
        return NBTHelper.writeCompoundList(ImmutableList.of((Object)this.first, (Object)this.second), serializer);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Couplerator(this);
    }

    public Stream<T> stream() {
        return Stream.of(this.first, this.second);
    }

    private static class Couplerator<T>
    implements Iterator<T> {
        private final Couple<T> couple;
        int state;

        public Couplerator(Couple<T> couple) {
            this.couple = couple;
            this.state = 0;
        }

        @Override
        public boolean hasNext() {
            return this.state != 2;
        }

        @Override
        public T next() {
            ++this.state;
            if (this.state == 1) {
                return (T)this.couple.first;
            }
            if (this.state == 2) {
                return (T)this.couple.second;
            }
            return null;
        }
    }
}

