/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.ManualBlockRenderState;
import com.zurrtum.create.compat.eiv.display.ManualApplicationDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class ManualApplicationView
extends CreateView {
    private final List<SlotContent> results;
    private final List<Float> chances;
    private final SlotContent target;
    private final SlotContent ingredient;
    private final boolean keepHeldItem;

    public ManualApplicationView(ManualApplicationDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.target = SlotContent.of(display.target);
        this.ingredient = SlotContent.of(display.ingredient);
        this.keepHeldItem = display.keepHeldItem;
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.ITEM_APPLICATION;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient, this.target);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    public int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int size = this.results.size();
        if (size == 1) {
            slotDefinition.addItemSlot(i++, 132, 34);
        } else {
            for (i = 0; i < size; ++i) {
                slotDefinition.addItemSlot(i, i % 2 == 0 ? 128 : 147, 34 + i / 2 * -19);
            }
        }
        slotDefinition.addItemSlot(i++, 51, 1);
        slotDefinition.addItemSlot(i++, 27, 34);
        return i;
    }

    @Override
    public int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.results.size();
        for (i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i, this.results.get(i), chance);
        }
        if (this.keepHeldItem) {
            slotFillContext.addAdditionalStackModifier(i, NOT_CONSUMED);
        }
        slotFillContext.bindOptionalSlot(i++, this.ingredient, SLOT);
        slotFillContext.bindOptionalSlot(i++, this.target, SLOT);
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_SHADOW.render(context, 67, 48);
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 79, 11);
        class_1799 stack = this.target.getByIndex(this.target.index());
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2680 block = blockItem.method_7711().method_9564();
            context.field_59826.method_70922((class_11256)new ManualBlockRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), block, 79, 30));
        }
    }
}

