/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.MillstoneRenderState;
import com.zurrtum.create.compat.eiv.display.CrushingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class MillingView
extends CreateView {
    private final List<SlotContent> results;
    private final SlotContent ingredient;
    private final List<Float> chances;

    public MillingView(CrushingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.ingredient = SlotContent.of(display.ingredient);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.MILLING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        slotDefinition.addItemSlot(0, 8, 5);
        int size = this.results.size();
        if (size == 1) {
            slotDefinition.addItemSlot(1, 132, 23);
        } else {
            for (int i = 0; i < size; ++i) {
                slotDefinition.addItemSlot(i + 1, i % 2 == 0 ? 126 : 145, 23 + i / 2 * -19);
            }
        }
        return size + 1;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindOptionalSlot(0, this.ingredient, SLOT);
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i + 1, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i + 1, this.results.get(i), chance);
        }
        return size + 1;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_ARROW.render(context, 78, 28);
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 36, 0);
        AllGuiTextures.JEI_SHADOW.render(context, 25, 36);
        context.field_59826.method_70922((class_11256)new MillstoneRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 35, 15));
    }
}

