/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.packet.c2s.BlueprintAssignCompleteRecipePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlueprintTransferHandler
implements IRecipeTransferHandler<BlueprintMenu, class_8786<class_3955>> {
    public Class<? extends BlueprintMenu> getContainerClass() {
        return BlueprintMenu.class;
    }

    public Optional<class_3917<BlueprintMenu>> getMenuType() {
        return Optional.empty();
    }

    public IRecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(BlueprintMenu menu, class_8786<class_3955> craftingRecipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        ArrayList<Object> inputViews = new ArrayList<Object>();
        ArrayList<Object> outputViews = new ArrayList<Object>();
        for (Object view : recipeSlots.getSlotViews()) {
            RecipeIngredientRole recipeIngredientRole = view.getRole();
            if (recipeIngredientRole == RecipeIngredientRole.INPUT) {
                inputViews.add(view);
                continue;
            }
            if (recipeIngredientRole != RecipeIngredientRole.OUTPUT) continue;
            outputViews.add(view);
        }
        class_1799 output = null;
        for (IRecipeSlotView iRecipeSlotView : outputViews) {
            Optional stack = iRecipeSlotView.getDisplayedItemStack();
            if (!stack.isPresent()) continue;
            output = (class_1799)stack.get();
            break;
        }
        if (output == null) {
            return new RecipeTransferErrorMissingSlots((class_2561)class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.missing"), outputViews);
        }
        ArrayList<class_6862<class_1792>> cache = new ArrayList<class_6862<class_1792>>();
        ArrayList<class_1799> arrayList = new ArrayList<class_1799>();
        for (IRecipeSlotView iRecipeSlotView : inputViews) {
            class_1799 filterItem;
            List<class_1799> ingredient = iRecipeSlotView.getItemStacks().toList();
            int size = ingredient.size();
            if (size == 0) {
                arrayList.add(class_1799.field_8037);
                continue;
            }
            if (size == 1) {
                arrayList.add((class_1799)ingredient.getFirst());
                continue;
            }
            class_6862<class_1792> tag = BlueprintTransferHandler.findTag(ingredient, cache);
            if (tag != null) {
                filterItem = AllItems.ATTRIBUTE_FILTER.method_7854();
                filterItem.method_57379(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)AttributeFilterWhitelistMode.WHITELIST_DISJ);
                filterItem.method_57379(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, List.of(new ItemAttributeEntry(new InTagAttribute(tag), false)));
                arrayList.add(filterItem);
                continue;
            }
            filterItem = AllItems.FILTER.method_7854();
            filterItem.method_57379(AllDataComponents.FILTER_ITEMS, (Object)class_9288.method_57493(ingredient));
            arrayList.add(filterItem);
        }
        BlueprintAssignCompleteRecipePacket packet = new BlueprintAssignCompleteRecipePacket(arrayList, output);
        ((class_746)player).field_3944.method_52787((class_2596)packet);
        return null;
    }

    @Nullable
    public static class_6862<class_1792> findTag(List<class_1799> ingredient, List<class_6862<class_1792>> cache) {
        List<class_6880.class_6883<class_1792>> list = BlueprintTransferHandler.getEntries(ingredient);
        for (class_6862<class_1792> tag2 : cache) {
            if (!BlueprintTransferHandler.matchTag(list, tag2)) continue;
            return tag2;
        }
        int size = list.size();
        return class_7923.field_41178.method_40272().filter(set -> set.method_40247() == size).map(class_6885.class_6888::method_40251).filter(t -> BlueprintTransferHandler.matchTag(list, (class_6862<class_1792>)t)).findFirst().map(tag -> {
            cache.add((class_6862<class_1792>)tag);
            return tag;
        }).orElse(null);
    }

    public static List<class_6880.class_6883<class_1792>> getEntries(List<class_1799> ingredient) {
        ArrayList<class_6880.class_6883<class_1792>> list = new ArrayList<class_6880.class_6883<class_1792>>(ingredient.size());
        for (class_1799 stack : ingredient) {
            list.add((class_6880.class_6883<class_1792>)stack.method_7909().method_40131());
        }
        return list;
    }

    public static boolean matchTag(List<class_6880.class_6883<class_1792>> list, class_6862<class_1792> tag) {
        for (class_6880.class_6883<class_1792> entry : list) {
            if (entry.method_40220(tag)) continue;
            return false;
        }
        return true;
    }
}

