/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.ResizableStorageArray;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.StagingBuffer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class LightBuffers {
    private final ResizableStorageArray lut = new ResizableStorageArray(4L);
    private final ResizableStorageArray sections = new ResizableStorageArray(LightStorage.SECTION_SIZE_BYTES);

    public void flush(StagingBuffer staging, LightStorage light) {
        int capacity = light.capacity();
        if (capacity == 0) {
            return;
        }
        this.sections.ensureCapacity(capacity);
        light.uploadChangedSections(staging, this.sections.handle());
        if (light.checkNeedsLutRebuildAndClear()) {
            IntArrayList lut = light.createLut();
            this.lut.ensureCapacity(lut.size());
            staging.enqueueCopy((long)lut.size() * 4L, this.lut.handle(), 0L, ptr -> {
                for (int i = 0; i < lut.size(); ++i) {
                    MemoryUtil.memPutInt((long)(ptr + (long)i * 4L), (int)lut.getInt(i));
                }
            });
        }
    }

    public void bind() {
        if (this.sections.capacity() == 0L) {
            return;
        }
        GL46.glBindBufferRange((int)37074, (int)5, (int)this.lut.handle(), (long)0L, (long)this.lut.byteCapacity());
        GL46.glBindBufferRange((int)37074, (int)6, (int)this.sections.handle(), (long)0L, (long)this.sections.byteCapacity());
    }

    public void delete() {
        this.lut.delete();
        this.sections.delete();
    }
}

