/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.client.content.contraptions.actors.contraptionControls.ControlsSlot;
import com.zurrtum.create.client.content.contraptions.actors.roller.RollerValueBox;
import com.zurrtum.create.client.content.fluids.pipes.SmartPipeFilterSlot;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerFilterSlot;
import com.zurrtum.create.client.content.kinetics.saw.SawFilterSlot;
import com.zurrtum.create.client.content.logistics.chute.SmartChuteFilterSlotPositioning;
import com.zurrtum.create.client.content.logistics.crate.CrateSlot;
import com.zurrtum.create.client.content.logistics.funnel.FunnelFilterSlotPositioning;
import com.zurrtum.create.client.content.logistics.itemHatch.HatchFilterSlot;
import com.zurrtum.create.client.content.processing.basin.BasinValueBox;
import com.zurrtum.create.client.content.redstone.FilteredDetectorFilterSlot;
import com.zurrtum.create.client.content.trains.observer.ObserverFilterSlot;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlockEntity;
import com.zurrtum.create.content.fluids.pipes.SmartFluidPipeBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.chute.SmartChuteBlockEntity;
import com.zurrtum.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.logistics.itemHatch.ItemHatchBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.trains.observer.TrackObserverBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class FilteringBehaviour<T extends ServerFilteringBehaviour>
extends BlockEntityBehaviour<SmartBlockEntity>
implements ValueSettingsBehaviour {
    public static final BehaviourType<FilteringBehaviour<?>> TYPE = new BehaviourType();
    protected T behaviour;
    protected ValueBoxTransform slotPositioning;
    public class_5250 customLabel;

    public FilteringBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be);
        this.behaviour = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        this.slotPositioning = slot;
    }

    @Override
    public void initialize() {
        if (this.behaviour == null) {
            this.behaviour = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        }
    }

    @Override
    public void tick() {
    }

    public static BlockEntityBehaviour<SmartBlockEntity> saw(SawBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new SawFilterSlot());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> basin(BasinBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new BasinValueBox());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> funnel(FunnelBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new FunnelFilterSlotPositioning());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> chute(SmartChuteBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new SmartChuteFilterSlotPositioning());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> deployer(DeployerBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new DeployerFilterSlot());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> pipe(SmartFluidPipeBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new SmartPipeFilterSlot());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> observer(SmartObserverBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new FilteredDetectorFilterSlot(false));
    }

    public static BlockEntityBehaviour<SmartBlockEntity> threshold(ThresholdSwitchBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new FilteredDetectorFilterSlot(true));
    }

    public static BlockEntityBehaviour<SmartBlockEntity> controls(ContraptionControlsBlockEntity blockEntity) {
        FilteringBehaviour filter = new FilteringBehaviour(blockEntity, new ControlsSlot());
        filter.setLabel(CreateLang.translateDirect("contraptions.contoller.target", new Object[0]));
        return filter;
    }

    public static BlockEntityBehaviour<SmartBlockEntity> crate(CreativeCrateBlockEntity blockEntity) {
        FilteringBehaviour filter = new FilteringBehaviour(blockEntity, new CrateSlot());
        filter.setLabel(CreateLang.translateDirect("logistics.creative_crate.supply", new Object[0]));
        return filter;
    }

    public static BlockEntityBehaviour<SmartBlockEntity> observer(TrackObserverBlockEntity blockEntity) {
        FilteringBehaviour filter = new FilteringBehaviour(blockEntity, new ObserverFilterSlot());
        filter.setLabel(CreateLang.translateDirect("logistics.train_observer.cargo_filter", new Object[0]));
        return filter;
    }

    public static BlockEntityBehaviour<SmartBlockEntity> roller(RollerBlockEntity blockEntity) {
        FilteringBehaviour filter = new FilteringBehaviour(blockEntity, new RollerValueBox(3));
        filter.setLabel(CreateLang.translateDirect("contraptions.mechanical_roller.pave_material", new Object[0]));
        return filter;
    }

    public static BlockEntityBehaviour<SmartBlockEntity> hatch(ItemHatchBlockEntity blockEntity) {
        return new FilteringBehaviour(blockEntity, new HatchFilterSlot());
    }

    public class_1799 getFilter(class_2350 side) {
        return ((ServerFilteringBehaviour)this.behaviour).getFilter(side);
    }

    public class_1799 getFilter() {
        return ((ServerFilteringBehaviour)this.behaviour).getFilter();
    }

    @Override
    public ValueSettings getValueSettings() {
        return ((ServerFilteringBehaviour)this.behaviour).getValueSettings();
    }

    public boolean isCountVisible() {
        return ((ServerFilteringBehaviour)this.behaviour).isCountVisible();
    }

    @Override
    public boolean acceptsValueSettings() {
        return ((ServerFilteringBehaviour)this.behaviour).isCountVisible();
    }

    @Override
    public boolean testHit(class_243 hit) {
        class_2680 state = this.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
        return this.slotPositioning.testHit((class_1936)this.getWorld(), this.getPos(), state, localHit);
    }

    public void setLabel(class_5250 label) {
        this.customLabel = label;
    }

    @Override
    public BehaviourType<? extends BlockEntityBehaviour<?>> getType() {
        return TYPE;
    }

    @Override
    public boolean isActive() {
        return ((ServerFilteringBehaviour)this.behaviour).isActive();
    }

    public float getRenderDistance() {
        return AllConfigs.client().filterItemRenderDistance.getF();
    }

    public class_5250 getLabel() {
        if (this.customLabel != null) {
            return this.customLabel;
        }
        return CreateLang.translateDirect(((ServerFilteringBehaviour)this.behaviour).isRecipeFilter() ? "logistics.recipe_filter" : (((ServerFilteringBehaviour)this.behaviour).fluidFilter ? "logistics.fluid_filter" : "logistics.filter"), new Object[0]);
    }

    public class_5250 getTip() {
        return CreateLang.translateDirect(((ServerFilteringBehaviour)this.behaviour).getFilter().method_7960() ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace", new Object[0]);
    }

    public class_5250 getAmountTip() {
        return CreateLang.translateDirect("logistics.filter.hold_to_set_amount", new Object[0]);
    }

    public class_5250 getCountLabelForValueBox() {
        return class_2561.method_43470((String)(((ServerFilteringBehaviour)this.behaviour).isCountVisible() ? (((ServerFilteringBehaviour)this.behaviour).upTo && ((ServerFilteringBehaviour)this.behaviour).getMaxStackSize() == ((ServerFilteringBehaviour)this.behaviour).count ? "*" : String.valueOf(((ServerFilteringBehaviour)this.behaviour).count)) : ""));
    }

    @Override
    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        int maxAmount = ((ServerFilteringBehaviour)this.behaviour).getMaxStackSize(hitResult.method_17780());
        return new ValueSettingsBoard((class_2561)CreateLang.translateDirect("logistics.filter.extracted_amount", new Object[0]), maxAmount, 16, CreateLang.translatedOptions("logistics.filter", "up_to", "exactly"), new ValueSettingsFormatter(this::formatValue));
    }

    public class_5250 formatValue(ValueSettings value) {
        if (value.row() == 0 && value.value() == ((ServerFilteringBehaviour)this.behaviour).getMaxStackSize()) {
            return CreateLang.translateDirect("logistics.filter.any_amount_short", new Object[0]);
        }
        return class_2561.method_43470((String)((value.row() == 0 ? "\u2264" : "=") + Math.max(1, value.value())));
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings valueSettings, boolean ctrlDown) {
        ((ServerFilteringBehaviour)this.behaviour).setValueSettings(player, valueSettings, ctrlDown);
    }

    @Override
    public boolean mayInteract(class_1657 player) {
        return this.behaviour.mayInteract(player);
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        ((ServerFilteringBehaviour)this.behaviour).onShortInteract(player, hand, side, hitResult);
    }

    @Override
    public int netId() {
        return ((ServerFilteringBehaviour)this.behaviour).netId();
    }
}

